/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatHandlerInfo;
import com.github.wallev.maidsoulkitchen.client.gui.widget.info.ResultInfo;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class CFRuleButton
extends Button
implements ITooltipButton {
    private static final ResourceLocation TEXTURE = VResourceLocation.create("maidsoulkitchen", "textures/gui/farm_guide.png");
    protected final ICompatHandlerInfo handlerInfo;
    protected final ICompatFarmHandler handler;
    private final List<ItemStack> blockItems = new ArrayList<ItemStack>();
    private final ResultInfo ref = new ResultInfo(1, 9, 8, 8, 2, 2);
    protected boolean isSelected;
    private final List<Component> tooltips;

    public CFRuleButton(ICompatHandlerInfo handlerInfo, ICompatFarmHandler handler, boolean isSelected, int pX, int pY, List<Component> tooltips) {
        super(pX, pY, 152, 24, (Component)Component.m_237119_(), b -> {}, Supplier::get);
        this.handlerInfo = handlerInfo;
        this.handler = handler;
        this.isSelected = isSelected;
        int i = 0;
        for (Block block : ForgeRegistries.BLOCKS) {
            if (i > 9) break;
            if (!handler.isFarmBlock(block)) continue;
            this.blockItems.add(new ItemStack((ItemLike)block));
            ++i;
        }
        this.tooltips = tooltips;
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.m_91087_();
        int pV0ffset = this.f_93622_ ? this.f_93619_ : 0;
        pGuiGraphics.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_(), 0, pV0ffset, this.f_93618_, this.f_93619_);
        pGuiGraphics.m_280218_(TEXTURE, this.m_252754_() + 3, this.m_252907_() + 3, 154, 3, 18, 18);
        pGuiGraphics.m_280480_(this.handlerInfo.getIcon(), this.m_252754_() + 4, this.m_252907_() + 4);
        pV0ffset = this.isSelected ? 0 : 24;
        pGuiGraphics.m_280218_(TEXTURE, this.m_252754_() + 131, this.m_252907_() + 3, 154, 3, 18, 18);
        pGuiGraphics.m_280218_(TEXTURE, this.m_252754_() + 131 + 1 + 1, this.m_252907_() + 3 + 1 + 1, 174, 5 + pV0ffset, 14, 14);
        pGuiGraphics.m_280614_(mc.f_91062_, (Component)this.handlerInfo.getName(), this.m_252754_() + 24, this.m_252907_() + 3, 0x404040, false);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        int i = 0;
        for (ItemStack itemStack : this.blockItems) {
            pGuiGraphics.m_280480_(itemStack, (this.m_252754_() + 24 + i++ * 10) * 2, (this.m_252907_() + 13) * 2);
        }
        pGuiGraphics.m_280168_().m_85849_();
    }

    public boolean isTooltipHovered() {
        return this.m_274382_();
    }

    public void renderTooltip(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        if (this.m_274382_()) {
            this.renderResStackTooltip(graphics, mc, mouseX, mouseY);
        }
    }

    private void renderResStackTooltip(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        int index = this.checkCoordinate2(mouseX, mouseY, this.m_252754_() + 24, this.m_252907_() + 13);
        if (index != -1 && index < this.blockItems.size()) {
            graphics.m_280153_(mc.f_91062_, this.blockItems.get(index), mouseX, mouseY);
        } else {
            graphics.m_280666_(mc.f_91062_, this.tooltips, mouseX, mouseY);
        }
    }

    private int checkCoordinate2(double pMouseX, double pMouseY, int startX, int startY) {
        if (pMouseX < (double)startX || pMouseY < (double)startY) {
            return -1;
        }
        int offsetRow = (int)(pMouseX - (double)startX);
        int offsetCol = (int)(pMouseY - (double)startY);
        if (offsetRow % (this.ref.rowWidth() + this.ref.rowSpacing()) < this.ref.rowWidth() && offsetCol % (this.ref.colHeight() + this.ref.colSpacing()) < this.ref.colHeight()) {
            int blockIndex;
            int blockCol = offsetRow / (this.ref.rowWidth() + this.ref.rowSpacing());
            int blockRow = offsetCol / (this.ref.colHeight() + this.ref.colSpacing());
            if (blockRow >= 0 && blockRow < this.ref.row() && blockCol >= 0 && blockCol < this.ref.col() && (blockIndex = blockRow * this.ref.col() + blockCol) >= 0 && blockIndex < this.ref.col() * this.ref.row()) {
                return blockIndex;
            }
        }
        return -1;
    }
}

