/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.storage.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.inv.IInvHandler;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.SimulateTargetInteractHelper;

@TaskClassAnalyzer(value=TaskInfo.MSM_CORE)
public class SimulateItemStackInteractHelper {
    public final BlockPos target;
    final ServerLevel level;
    @Nullable
    final Player opener;
    private final EntityMaid maid;
    @Nullable
    public IInvHandler iInvHandler;
    int currentSlot = 0;
    int restTick = 0;
    int countPreTick = 10;
    boolean notOpener = false;

    public SimulateItemStackInteractHelper(EntityMaid maid, BlockPos targetPos, @Nullable Direction side, ServerLevel level) {
        this.maid = maid;
        this.target = targetPos;
        this.level = level;
        this.opener = SimulateTargetInteractHelper.ChestOpener.getOrCreate((ServerLevel)level, (EntityMaid)maid);
        this.iInvHandler = (IInvHandler)maid.m_21205_().getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (this.iInvHandler != null && this.iInvHandler.kl$getSlots() > 60) {
            this.countPreTick = this.iInvHandler.kl$getSlots() / 6;
        }
    }

    protected boolean isStillValid() {
        return this.iInvHandler != null;
    }

    private Optional<ContainerOpenersCounter> trySeekCounter(BlockEntity blockEntity) {
        Field[] fields;
        for (Field field : fields = blockEntity.getClass().getDeclaredFields()) {
            if (!field.getType().equals(ContainerOpenersCounter.class)) continue;
            try {
                field.setAccessible(true);
                return Optional.of((ContainerOpenersCounter)field.get(blockEntity));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (blockEntity instanceof WorldlyContainer) {
            final WorldlyContainer wc = (WorldlyContainer)blockEntity;
            return Optional.of(new ContainerOpenersCounter(){

                public void m_155468_(Player p_155469_, Level p_155470_, BlockPos p_155471_, BlockState p_155472_) {
                    wc.m_5785_(p_155469_);
                }

                public void m_155452_(Player p_155453_, Level p_155454_, BlockPos p_155455_, BlockState p_155456_) {
                    wc.m_5856_(p_155453_);
                }

                protected void m_142292_(Level p_155460_, BlockPos p_155461_, BlockState p_155462_) {
                }

                protected void m_142289_(Level p_155473_, BlockPos p_155474_, BlockState p_155475_) {
                }

                protected void m_142148_(Level p_155463_, BlockPos p_155464_, BlockState p_155465_, int p_155466_, int p_155467_) {
                }

                protected boolean m_142718_(Player p_155451_) {
                    return false;
                }
            });
        }
        return Optional.empty();
    }

    public boolean doneTaking() {
        if (this.restTick > 0) {
            return false;
        }
        if (!this.isStillValid()) {
            return true;
        }
        return this.iInvHandler == null || this.currentSlot >= this.iInvHandler.kl$getSlots();
    }

    public boolean doneViewing() {
        return this.doneTaking();
    }

    public void open() {
    }

    public void takeItemTick(Function<ItemStack, ItemStack> cb) {
        if (this.iInvHandler == null) {
            return;
        }
        int count = 0;
        while (this.currentSlot < this.iInvHandler.kl$getSlots() && ++count < this.countPreTick) {
            ItemStack result;
            ItemStack copy = this.iInvHandler.kl$extractItem(this.currentSlot, this.iInvHandler.kl$getStackInSlot(this.currentSlot).m_41613_(), true).m_41777_();
            int originalCount = copy.m_41613_();
            if (!copy.m_41619_() && (result = cb.apply(copy)).m_41613_() != originalCount) {
                this.iInvHandler.kl$extractItem(this.currentSlot, originalCount - result.m_41613_(), false);
                break;
            }
            ++this.currentSlot;
        }
    }

    public void viewItemTick(Consumer<ItemStack> cb) {
        if (this.iInvHandler == null) {
            return;
        }
        int count = 0;
        while (this.currentSlot < this.iInvHandler.kl$getSlots() && ++count < this.countPreTick) {
            ItemStack stack = this.iInvHandler.kl$getStackInSlot(this.currentSlot);
            if (!stack.m_41619_()) {
                cb.accept(stack);
            }
            ++this.currentSlot;
        }
    }

    public void reset() {
        this.currentSlot = 0;
    }

    public void stop() {
    }
}

