/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.cuisinedelight.cuisine;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.logic.FoodType;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.init.registrate.CDMisc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class VirtualCookedFoodData {
    public static void makeValidRecipes(Level level) {
        level.m_7465_().m_44013_((RecipeType)CDMisc.RT_CUISINE.get()).forEach(recipe -> {
            NonNullList ingredients = recipe.m_7527_();
            ItemStack resultItem = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
            if (ingredients.isEmpty()) {
                return;
            }
            List<List> flatIngredients = ingredients.stream().map(ingredient -> Arrays.stream(ingredient.m_43908_()).toList()).toList();
            MaidsoulKitchen.LOGGER.debug("Start checker all ingredients");
            if (flatIngredients.size() > 1) {
                List ingredient0 = flatIngredients.get(0);
                List ingredient1 = flatIngredients.get(1);
                for (ItemStack itemStack0 : ingredient0) {
                    for (ItemStack itemStack1 : ingredient1) {
                        CookedFoodData cookedFoodData = VirtualCookedFoodData.create(List.of(itemStack0, itemStack1));
                        ItemStack bestItemStack = VirtualCookedFoodData.getBestItemStack(level, cookedFoodData);
                        if (bestItemStack.m_150930_(resultItem.m_41720_())) continue;
                        MaidsoulKitchen.LOGGER.error("No single ingredients to make food[two ingredients]: {} {} {} {}", (Object)itemStack0, (Object)itemStack1, (Object)bestItemStack, (Object)resultItem);
                    }
                }
            } else {
                for (ItemStack itemStack : flatIngredients.get(0)) {
                    CookedFoodData cookedFoodData = VirtualCookedFoodData.create(List.of(itemStack));
                    ItemStack bestItemStack = VirtualCookedFoodData.getBestItemStack(level, cookedFoodData);
                    if (bestItemStack.m_150930_(resultItem.m_41720_())) continue;
                    MaidsoulKitchen.LOGGER.error("No single ingredients to make food[one ingredients]: {} {} {}", (Object)itemStack, (Object)bestItemStack, (Object)resultItem);
                }
            }
            MaidsoulKitchen.LOGGER.debug("End checker all ingredients");
        });
    }

    public static ItemStack getBestItemStack(Level level, CookedFoodData data) {
        ItemStack bestMatch = BaseCuisineRecipe.findBestMatch((Level)level, (CookedFoodData)data);
        return bestMatch;
    }

    public static CookedFoodData create(List<ItemStack> itemStacks) {
        CookedFoodData cookedFoodData = new CookedFoodData();
        int size = 0;
        int nutrition = 0;
        float penalty = 0.0f;
        for (ItemStack item : itemStacks) {
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(item);
            if (config == null) continue;
            int itemSize = config.size * item.m_41613_();
            penalty += (float)itemSize * 0.0f;
            size += itemSize;
            nutrition += config.nutrition * itemSize;
            cookedFoodData.entries.add(new CookedFoodData.Entry(item, itemSize, false, false, false));
            if (config.type == FoodType.NONE) continue;
            cookedFoodData.types.add(config.type);
        }
        float goodness = size == 0 ? 0.0f : Mth.m_14036_((float)(1.0f - penalty / (float)size), (float)0.0f, (float)1.0f);
        cookedFoodData.score = 100;
        cookedFoodData.size = size;
        cookedFoodData.total = size;
        cookedFoodData.nutrition = size == 0 ? 0 : Math.round(goodness * (float)nutrition / (float)size);
        cookedFoodData.glowstone = 0;
        cookedFoodData.redstone = 0;
        return cookedFoodData;
    }

    public static void makeValidRecipes0(Level level) {
        HashMap vaildRecips = new HashMap();
        level.m_7465_().m_44013_((RecipeType)CDMisc.RT_CUISINE.get()).forEach(recipe -> {
            List<Ingredient> ingredients = recipe.list.stream().map(l -> l.ingredient()).toList();
            ItemStack resultItem = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
            if (ingredients.isEmpty()) {
                return;
            }
            List<List> flatIngredients = ingredients.stream().map(ingredient -> Arrays.stream(ingredient.m_43908_()).toList()).toList();
            MaidsoulKitchen.LOGGER.debug("----------------------------------------------------------------------");
            MaidsoulKitchen.LOGGER.debug("Start checker all ingredients: {}", (Object)resultItem);
            for (List flatIngredient : flatIngredients) {
                MaidsoulKitchen.LOGGER.debug("ingredients: {}", (Object)flatIngredient);
            }
            if (flatIngredients.size() > 1) {
                List ingredient0 = flatIngredients.get(0);
                List ingredient1 = flatIngredients.get(1);
                for (ItemStack itemStack0 : ingredient0) {
                    for (ItemStack itemStack1 : ingredient1) {
                        CookedFoodData cookedFoodData = VirtualCookedFoodData.create(List.of(itemStack0, itemStack1));
                        ItemStack bestItemStack = VirtualCookedFoodData.getBestItemStack(level, cookedFoodData);
                        if (!bestItemStack.m_150930_(resultItem.m_41720_())) {
                            MaidsoulKitchen.LOGGER.error("Make other food[two ingredients]: {} {} {}", (Object)itemStack0, (Object)itemStack1, (Object)bestItemStack);
                        }
                        boolean add = false;
                        for (Map.Entry entry : vaildRecips.entrySet()) {
                            CompoundTag resultCompoundTag;
                            int resultTotal;
                            CompoundTag keyCompoundTag;
                            int keyTotal;
                            ItemStack key2 = (ItemStack)entry.getKey();
                            if (!key2.m_150930_(bestItemStack.m_41720_()) || (keyTotal = (keyCompoundTag = key2.m_41784_()).m_128451_("total")) != (resultTotal = (resultCompoundTag = key2.m_41784_()).m_128451_("total"))) continue;
                            ((List)entry.getValue()).add(Pair.of((Object)itemStack0, (Object)itemStack1));
                            add = true;
                            break;
                        }
                        if (add) continue;
                        vaildRecips.computeIfAbsent(bestItemStack, key -> new ArrayList()).add(Pair.of((Object)itemStack0, (Object)itemStack1));
                    }
                }
            } else {
                for (ItemStack itemStack : flatIngredients.get(0)) {
                    CookedFoodData cookedFoodData = VirtualCookedFoodData.create(List.of(itemStack));
                    ItemStack bestItemStack = VirtualCookedFoodData.getBestItemStack(level, cookedFoodData);
                    if (!bestItemStack.m_150930_(resultItem.m_41720_())) {
                        MaidsoulKitchen.LOGGER.error("Make other food[one ingredients]: {} {}", (Object)itemStack, (Object)bestItemStack);
                    }
                    boolean add = false;
                    for (Map.Entry entry : vaildRecips.entrySet()) {
                        CompoundTag resultCompoundTag;
                        int resultTotal;
                        CompoundTag keyCompoundTag;
                        int keyTotal;
                        ItemStack key3 = (ItemStack)entry.getKey();
                        if (!key3.m_150930_(bestItemStack.m_41720_()) || (keyTotal = (keyCompoundTag = key3.m_41784_()).m_128451_("total")) != (resultTotal = (resultCompoundTag = key3.m_41784_()).m_128451_("total"))) continue;
                        ((List)entry.getValue()).add(Pair.of((Object)itemStack, (Object)ItemStack.f_41583_));
                        add = true;
                        break;
                    }
                    if (add) continue;
                    vaildRecips.computeIfAbsent(bestItemStack, key -> new ArrayList()).add(Pair.of((Object)itemStack, (Object)ItemStack.f_41583_));
                }
            }
            MaidsoulKitchen.LOGGER.debug("****************************************************");
        });
        HashMap convert = new HashMap();
        new HashMap(vaildRecips).entrySet().stream().flatMap(entry -> {
            ItemStack result = (ItemStack)entry.getKey();
            List inputs = (List)entry.getValue();
            HashMap flatRecipes = new HashMap();
            inputs.forEach(oInput -> {
                if (((ItemStack)oInput.getSecond()).m_41619_()) {
                    IntStream.range(0, 9).forEach(i -> {
                        ArrayList<ItemStack> jInput = new ArrayList<ItemStack>();
                        for (int j = 0; j < i + 1; ++j) {
                            jInput.add((ItemStack)oInput.getFirst());
                        }
                        ItemStack copy = result.m_41777_();
                        CompoundTag compoundTag = copy.m_41784_();
                        CompoundTag resultCompoundTag = compoundTag.m_128469_("CookedFoodData");
                        int resultTotal = resultCompoundTag.m_128451_("total");
                        resultCompoundTag.m_128405_("total", resultTotal * (i + 1));
                        copy.m_41751_(compoundTag);
                        copy.m_41764_(resultTotal * (i + 1));
                        boolean add = false;
                        for (Map.Entry o : flatRecipes.entrySet()) {
                            CompoundTag oresultCompoundTag;
                            int oresultTotal;
                            ItemStack key2 = (ItemStack)o.getKey();
                            if (!key2.m_150930_(copy.m_41720_()) || (oresultTotal = (oresultCompoundTag = key2.m_41784_().m_128469_("CookedFoodData")).m_128451_("total") * (i + 1)) != resultTotal) continue;
                            ((List)o.getValue()).addAll(jInput);
                            add = true;
                            break;
                        }
                        if (!add) {
                            flatRecipes.computeIfAbsent(copy, key -> new ArrayList()).addAll(jInput);
                        }
                    });
                } else {
                    IntStream.range(0, 4).forEach(i -> {
                        ArrayList<ItemStack> jInput = new ArrayList<ItemStack>();
                        for (int j = 0; j < i + 1; ++j) {
                            jInput.add((ItemStack)oInput.getFirst());
                            jInput.add((ItemStack)oInput.getSecond());
                        }
                        ItemStack copy = result.m_41777_();
                        CompoundTag compoundTag = copy.m_41784_();
                        CompoundTag resultCompoundTag = compoundTag.m_128469_("CookedFoodData");
                        int resultTotal = resultCompoundTag.m_128451_("total");
                        resultCompoundTag.m_128405_("total", resultTotal * (i + 1));
                        copy.m_41751_(compoundTag);
                        copy.m_41764_(resultTotal * (i + 1));
                        boolean add = false;
                        for (Map.Entry o : flatRecipes.entrySet()) {
                            CompoundTag oresultCompoundTag;
                            int oresultTotal;
                            ItemStack key2 = (ItemStack)o.getKey();
                            if (!key2.m_150930_(copy.m_41720_()) || (oresultTotal = (oresultCompoundTag = key2.m_41784_().m_128469_("CookedFoodData")).m_128451_("total") * (i + 1)) != resultTotal) continue;
                            ((List)o.getValue()).addAll(jInput);
                            add = true;
                            break;
                        }
                        if (!add) {
                            flatRecipes.computeIfAbsent(copy, key -> new ArrayList()).addAll(jInput);
                        }
                    });
                }
            });
            return flatRecipes.entrySet().stream();
        }).forEach(itemStackListEntry -> convert.put((ItemStack)itemStackListEntry.getKey(), (List)itemStackListEntry.getValue()));
        boolean a = true;
    }

    public static ItemStack getBestItemStack0(Level level, CookedFoodData data) {
        ItemStack bestMatch = BaseCuisineRecipe.findBestMatch((Level)level, (CookedFoodData)data);
        return bestMatch;
    }

    public static CookedFoodData create0(List<ItemStack> itemStacks) {
        CookedFoodData cookedFoodData = new CookedFoodData();
        int size = 0;
        int nutrition = 0;
        float penalty = 0.0f;
        for (ItemStack item : itemStacks) {
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(item);
            if (config == null) continue;
            int itemSize = config.size * item.m_41613_();
            penalty += (float)itemSize * 0.0f;
            size += itemSize;
            nutrition += config.nutrition * itemSize;
            cookedFoodData.entries.add(new CookedFoodData.Entry(item, itemSize, false, false, false));
            if (config.type == FoodType.NONE) continue;
            cookedFoodData.types.add(config.type);
        }
        float goodness = size == 0 ? 0.0f : Mth.m_14036_((float)(1.0f - penalty / (float)size), (float)0.0f, (float)1.0f);
        cookedFoodData.score = 100;
        cookedFoodData.size = size;
        cookedFoodData.total = size;
        cookedFoodData.nutrition = size == 0 ? 0 : Math.round(goodness * (float)nutrition / (float)size);
        cookedFoodData.glowstone = 0;
        cookedFoodData.redstone = 0;
        return cookedFoodData;
    }
}

