/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.config.subconfig;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class TaskConfig {
    public static ForgeConfigSpec.ConfigValue<List<List<String>>> MELON_AND_STEM_LIST;
    public static ForgeConfigSpec.ConfigValue<List<String>> BLACK_HUB_CHEST_LIST;
    public static ForgeConfigSpec.ConfigValue<Integer> FEED_SINGLE_ANIMAL_MAX_NUMBER;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.push("Task");
        builder.comment(new String[]{"These entries configure the melon stem and melon_block item list.", "rule: [melon_block_id, attached_melon_stem_block_id]", "Eg: [\"minecraft:melon\", \"minecraft:attached_melon_stem\"]"});
        MELON_AND_STEM_LIST = builder.define("MelonAndStemList", TaskConfig.getmelonAndStemList());
        builder.comment("A list of blocks that the Culinary Hub cannot interact with.");
        BLACK_HUB_CHEST_LIST = builder.define("BlackHubChestList", (Object)Lists.newArrayList());
        builder.comment("The max number of the different type animal around when the maid breeds animals");
        FEED_SINGLE_ANIMAL_MAX_NUMBER = builder.defineInRange("FeedSingleAnimalMaxNumber", 20, 6, 65536);
        builder.pop();
    }

    private static List<List<String>> getmelonAndStemList() {
        ArrayList<List<String>> melonStemList = new ArrayList<List<String>>();
        melonStemList.add(Arrays.asList("simplefarming:cantaloupe", "simplefarming:attached_cantaloupe_stem"));
        melonStemList.add(Arrays.asList("simplefarming:honeydew", "simplefarming:attached_honeydew_stem"));
        melonStemList.add(Arrays.asList("simplefarming:squash", "simplefarming:attached_squash_stem"));
        return melonStemList;
    }
}

