/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.datagen.recipe.itemuse;

import com.github.wallev.maidsoulkitchen.init.ModRecipes;
import com.github.wallev.maidsoulkitchen.recipe.itemuse.ItemUseRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemUseRecipeBuilder
implements RecipeBuilder {
    private ItemUseRecipe.Condition type = ItemUseRecipe.Condition.SINGLE;
    private final List<ItemStack> inputs = new ArrayList<ItemStack>();
    private final List<ItemStack> results = new ArrayList<ItemStack>();

    public static ItemUseRecipeBuilder builder() {
        return new ItemUseRecipeBuilder();
    }

    public ItemUseRecipeBuilder setType(ItemUseRecipe.Condition type) {
        this.type = type;
        return this;
    }

    public ItemUseRecipeBuilder setInputs(ItemStack ... stack) {
        this.inputs.addAll(List.of(stack));
        return this;
    }

    public ItemUseRecipeBuilder setInput(ItemStack stack) {
        this.inputs.add(stack);
        return this;
    }

    public ItemUseRecipeBuilder setInput(ItemLike itemLike) {
        this.inputs.add(new ItemStack(itemLike));
        return this;
    }

    public ItemUseRecipeBuilder setInput(ItemLike itemLike, int count) {
        this.inputs.add(new ItemStack(itemLike, count));
        return this;
    }

    public ItemUseRecipeBuilder setResults(ItemStack ... stack) {
        this.results.addAll(List.of(stack));
        return this;
    }

    public ItemUseRecipeBuilder setResult(ItemStack stack) {
        this.results.add(stack);
        return this;
    }

    public ItemUseRecipeBuilder setResult(ItemLike itemLike) {
        this.results.add(new ItemStack(itemLike));
        return this;
    }

    public ItemUseRecipeBuilder setResult(ItemLike itemLike, int count) {
        this.results.add(new ItemStack(itemLike, count));
        return this;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return this.results.get(0).m_41720_();
    }

    public void m_176498_(Consumer<FinishedRecipe> output) {
        String path = RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_135815_();
        ResourceLocation filePath = new ResourceLocation("maidsoulkitchen", this.type.toString() + "_item_use/" + path);
        this.m_126140_(output, filePath);
    }

    public void m_176500_(Consumer<FinishedRecipe> output, String recipeId) {
        ResourceLocation filePath = new ResourceLocation("maidsoulkitchen", this.type.toString() + "_item_use/" + recipeId);
        this.m_126140_(output, filePath);
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeOutput, ResourceLocation id) {
        recipeOutput.accept(new ItemUseRecipe(this.type, id, this.inputs, this.results));
    }

    public record ItemUseRecipe(ItemUseRecipe.Condition type, ResourceLocation id, List<ItemStack> input, List<ItemStack> result) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.addProperty("condition", this.type.toString());
            JsonArray inputsJson = new JsonArray();
            for (ItemStack itemStack : this.input) {
                JsonObject inputJson = new JsonObject();
                inputJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString());
                CompoundTag inputTag = itemStack.m_41783_();
                if (inputTag != null) {
                    String string = inputTag.toString();
                    inputJson.addProperty("nbt", string);
                }
                inputsJson.add((JsonElement)inputJson);
            }
            json.add("inputs", (JsonElement)inputsJson);
            JsonArray resultsJson = new JsonArray();
            for (ItemStack itemStack : this.result) {
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString());
                CompoundTag inputTag = itemStack.m_41783_();
                if (inputTag != null) {
                    String string = inputTag.toString();
                    resultJson.addProperty("nbt", string);
                }
                resultsJson.add((JsonElement)resultJson);
            }
            json.add("results", (JsonElement)resultsJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.ITEM_USE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

