/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v0;

import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.world.item.crafting.Recipe;

@Deprecated(since="0.2.0")
public class CookData {
    public static final Codec<List<String>> LIST_CODEC = Codec.STRING.listOf().xmap(Lists::newArrayList, Function.identity());
    public static final Codec<CookData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Mode").forGetter(CookData::mode), (App)LIST_CODEC.fieldOf("WhitelistRecs").forGetter(CookData::whitelistRecs), (App)LIST_CODEC.fieldOf("BlacklistRecs").forGetter(CookData::blacklistRecs)).apply((Applicative)instance, CookData::new));
    private String mode;
    private List<String> whitelistRecs;
    private List<String> blacklistRecs;

    public CookData() {
        this(Lists.newArrayList());
    }

    public CookData(List<String> blacklistRecs) {
        this(Lists.newArrayList(), blacklistRecs);
    }

    public CookData(List<String> whitelistRecs, List<String> blacklistRecs) {
        this(Mode.BLACKLIST.name, whitelistRecs, blacklistRecs);
    }

    public CookData(String mode, List<String> whitelistRecs, List<String> blacklistRecs) {
        this.mode = mode;
        this.whitelistRecs = whitelistRecs;
        this.blacklistRecs = blacklistRecs;
    }

    public void addOrRemoveRec(String rec, String mode) {
        switch (mode) {
            case "whitelist": {
                if (this.whitelistRecs.contains(rec)) {
                    this.whitelistRecs.remove(rec);
                    break;
                }
                this.whitelistRecs.add(rec);
                break;
            }
            case "blacklist": {
                if (this.blacklistRecs.contains(rec)) {
                    this.blacklistRecs.remove(rec);
                    break;
                }
                this.blacklistRecs.add(rec);
            }
        }
    }

    public void addRecs(List<String> recs) {
        switch (this.mode) {
            case "whitelist": {
                for (String rec : recs) {
                    if (this.whitelistRecs.contains(rec)) continue;
                    this.whitelistRecs.add(rec);
                }
                break;
            }
            case "blacklist": {
                for (String rec : recs) {
                    if (this.blacklistRecs.contains(rec)) continue;
                    this.blacklistRecs.add(rec);
                }
                break;
            }
        }
    }

    public void removeRecs(List<String> recs) {
        switch (this.mode) {
            case "whitelist": {
                for (String rec : recs) {
                    this.whitelistRecs.remove(rec);
                }
                break;
            }
            case "blacklist": {
                for (String rec : recs) {
                    this.blacklistRecs.remove(rec);
                }
                break;
            }
        }
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<String> whitelistRecs() {
        return this.whitelistRecs;
    }

    public List<String> blacklistRecs() {
        return this.blacklistRecs;
    }

    public String mode() {
        return this.mode;
    }

    public List<String> getRecs() {
        if (this.isWhitelistMode()) {
            return this.whitelistRecs;
        }
        return this.blacklistRecs;
    }

    public boolean isWhitelistMode() {
        return Mode.byName(this.mode).isWhitelistMode();
    }

    public boolean canCook(String recId) {
        switch (this.mode) {
            case "whitelist": {
                return this.whitelistRecs.contains(recId);
            }
            case "blacklist": {
                return !this.blacklistRecs.contains(recId);
            }
        }
        return false;
    }

    public boolean canCook(Recipe<?> r) {
        return this.canCook(r.m_6423_().toString());
    }

    public boolean canCook(MKRecipe<?> mkr) {
        return this.canCook(mkr.idStr());
    }

    public static enum Mode {
        WHITELIST("whitelist"),
        BLACKLIST("blacklist");

        public final String name;

        private Mode(String name) {
            this.name = name;
        }

        public static boolean isWhitelistMode(String name) {
            return Mode.byName(name).isWhitelistMode();
        }

        public static Mode byName(String name) {
            return Mode.valueOf(name.toUpperCase(Locale.ENGLISH));
        }

        public boolean isWhitelistMode() {
            return this == WHITELIST;
        }
    }
}

