/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.ModClazzChecker;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.IMods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ModTaskMixin;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ModTaskMixinMap;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.spongepowered.asm.mixin.Mixin;

public final class TaskMixinAnalyzer {
    private static final String FILE_NAME = "mod_task_mixin_clazz.json";
    public static final Function<Codec<IMods>, Codec<ModTaskMixin>> MOD_TASK_MIXIN_CODEC = mc -> RecordCodecBuilder.create(ins -> ins.group((App)Codec.STRING.fieldOf("taskUid").forGetter(o -> o.taskUid()), (App)mc.fieldOf("compatMod").forGetter(o -> o.compatMod()), (App)Codec.STRING.listOf().fieldOf("mixinList").forGetter(ModTaskMixin::mixinList)).apply((Applicative)ins, ModTaskMixin::new));
    public static final Function<Codec<IMods>, Codec<ModTaskMixinMap>> MOD_TASK_MIXIN_MAP_CODEC = mc -> RecordCodecBuilder.create(ins -> ins.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)MOD_TASK_MIXIN_CODEC.apply((Codec<IMods>)mc).listOf()).fieldOf("list").forGetter(ModTaskMixinMap::map)).apply((Applicative)ins, ModTaskMixinMap::new));

    public static void writeModTaskClazz(Path rootOutputFolder, BaseClazzCheckManager<?, ?> checkManager) {
        ModTaskMixinMap modTaskClazz = TaskMixinAnalyzer.collectModTaskClazz(checkManager);
        MOD_TASK_MIXIN_MAP_CODEC.apply(checkManager.getModsCodecO()).encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)modTaskClazz).resultOrPartial(error -> ModClazzChecker.LOGGER.error("\u751f\u6210\u5931\u8d25\uff1a{}", error)).ifPresent(data -> {
            File file = new File(rootOutputFolder.toString().replace("generated", "main") + "\\mod_task_mixin_clazz.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(gson.toJson(data));
                fileWriter.close();
                ModClazzChecker.LOGGER.info("\u751f\u6210\u6210\u529f\uff1a{}", (Object)file.getPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static ModTaskMixinMap readModTaskClazz(BaseClazzCheckManager<?, ?> checkManager) {
        try {
            Path resource = LoadingModList.get().getModFileById(checkManager.getModId()).getFile().findResource(new String[]{FILE_NAME});
            String json = Files.readString(resource);
            JsonObject jsonData = JsonParser.parseString((String)json).getAsJsonObject();
            return (ModTaskMixinMap)MOD_TASK_MIXIN_MAP_CODEC.apply(checkManager.getModsCodecO()).parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonData).result().orElseThrow();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ModTaskMixinMap collectModTaskClazz(BaseClazzCheckManager<?, ?> checkManager) {
        HashMap targetBindInfo = new HashMap();
        HashMap taskMixinList = new HashMap();
        HashMap<String, Set> classInfo = new HashMap<String, Set>();
        HashMap<String, Set> classInfo0 = new HashMap<String, Set>();
        HashMap<String, Set> mixinMap = new HashMap<String, Set>();
        HashMap<String, Set> mixinResourceMap = new HashMap<String, Set>();
        Type taskMixinType = checkManager.getTaskClazzMixinAnnotationType();
        Type mixinType = Type.getType(Mixin.class);
        List allScanData = ModList.get().getAllScanData();
        for (ModFileScanData scanData : allScanData) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                Type annotationedType = data.annotationType();
                if (Objects.equals(annotationedType, taskMixinType)) {
                    List<ModAnnotation.EnumHolder> taskEnum = TaskMixinAnalyzer.getEnumHolderValue(data, "value");
                    for (ModAnnotation.EnumHolder enumHolder : taskEnum) {
                        Object task = checkManager.taskInfoByKey(enumHolder.getValue());
                        targetBindInfo.put(task.getUidStr(), task.getBindMod());
                        classInfo.computeIfAbsent(data.memberName(), name -> new HashSet()).add(task.getUidStr());
                        mixinResourceMap.computeIfAbsent(data.memberName(), name -> new HashSet()).add(task.getUidStr());
                    }
                }
                if (!Objects.equals(annotationedType, mixinType) || !data.memberName().startsWith(checkManager.getMixinPackage())) continue;
                ArrayList<String> list = new ArrayList<String>();
                if (data.annotationData().get("value") != null) {
                    String string = ((List)data.annotationData().get("value")).get(0).toString();
                    string = string.substring(1, string.length() - 1);
                    list.add(string.replace("/", "."));
                }
                if (data.annotationData().get("targets") != null) {
                    List targets = (List)data.annotationData().get("targets");
                    for (String target : targets) {
                        list.add(target.replace("/", "."));
                    }
                }
                mixinMap.computeIfAbsent(data.memberName(), uid -> new HashSet()).addAll(list);
                classInfo0.computeIfAbsent(data.memberName(), uid -> new HashSet()).addAll(list);
            }
        }
        classInfo0.forEach((key, val) -> {
            Set set = classInfo.getOrDefault(key, new HashSet());
            for (String resourceLocation : set) {
                taskMixinList.computeIfAbsent(resourceLocation, uid -> new HashSet()).addAll(val);
            }
        });
        HashMap<String, Set<ModTaskMixin>> map = new HashMap<String, Set<ModTaskMixin>>();
        mixinMap.forEach((key, value) -> {
            Set set = mixinResourceMap.getOrDefault(key, new HashSet());
            for (String taskUid : set) {
                IMods mod = (IMods)targetBindInfo.get(taskUid);
                ModTaskMixin modTaskMixin = ModTaskMixin.create(taskUid, mod, value);
                map.computeIfAbsent(taskUid, uid -> new HashSet()).add(modTaskMixin);
            }
        });
        return ModTaskMixinMap.create(map);
    }

    private static List<ModAnnotation.EnumHolder> getEnumHolderValue(ModFileScanData.AnnotationData data, String name) {
        return (List)data.annotationData().get(name);
    }
}

