/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.SignatureConverter;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class McMethodOrFieldVerify {
    private static final Map<String, Map<String, List<String>>> METHOD_MAP = new HashMap<String, Map<String, List<String>>>();
    private static final Map<String, Map<String, List<String>>> FIELD_MAP = new HashMap<String, Map<String, List<String>>>();

    static boolean isMcMethod(String targetClazzName, String methodName, BaseClazzCheckManager<?, ?> checkManager) throws ClassNotFoundException {
        Map<String, List<String>> allMethodsIncludingInherited = McMethodOrFieldVerify.getAllMethodsIncludingInherited(targetClazzName);
        for (Map.Entry<String, List<String>> entry : allMethodsIncludingInherited.entrySet()) {
            String clazz = entry.getKey();
            if (!McMethodOrFieldVerify.isMinecraftClazz(clazz, checkManager)) continue;
            List<String> value = entry.getValue();
            for (String s : value) {
                if (!s.equals(methodName)) continue;
                return true;
            }
        }
        return false;
    }

    static Map<String, List<String>> getAllMethodsIncludingInherited(String targetClass) throws ClassNotFoundException {
        String targetClassName = targetClass;
        if (METHOD_MAP.containsKey(targetClassName)) {
            return METHOD_MAP.get(targetClassName);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        LinkedHashSet members = new LinkedHashSet();
        LinkedList classesToProcess = new LinkedList();
        HashSet<Class> processedClasses = new HashSet<Class>();
        classesToProcess.add(Class.forName(targetClass));
        while (!classesToProcess.isEmpty()) {
            Class currentClass = (Class)classesToProcess.pop();
            String name = currentClass.getName();
            if (map.containsKey(name) || currentClass == null || processedClasses.contains(currentClass)) continue;
            processedClasses.add(currentClass);
            HashSet<String> sets = new HashSet<String>();
            List<String> list = Arrays.stream(currentClass.getDeclaredConstructors()).map(c -> SignatureConverter.toASMStringWithoutClazz(c)).toList();
            sets.addAll(list);
            List<String> list1 = Arrays.stream(currentClass.getDeclaredMethods()).map(m -> SignatureConverter.toASMStringWithoutClazz(m)).toList();
            sets.addAll(list1);
            map.put(name, Lists.newArrayList(sets));
            if (currentClass.getSuperclass() != null) {
                classesToProcess.add(currentClass.getSuperclass());
            }
            classesToProcess.addAll(Arrays.asList(currentClass.getInterfaces()));
        }
        METHOD_MAP.put(targetClassName, map);
        return map;
    }

    static boolean isMcField(String targetClazzName, String fieldName, BaseClazzCheckManager<?, ?> checkManager) throws ClassNotFoundException {
        Map<String, List<String>> allMethodsIncludingInherited = McMethodOrFieldVerify.getAllFieldsIncludingInherited(targetClazzName);
        for (Map.Entry<String, List<String>> entry : allMethodsIncludingInherited.entrySet()) {
            String clazz = entry.getKey();
            if (!McMethodOrFieldVerify.isMinecraftClazz(clazz, checkManager)) continue;
            List<String> value = entry.getValue();
            for (String s : value) {
                if (!s.equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    static Map<String, List<String>> getAllFieldsIncludingInherited(String targetClass) throws ClassNotFoundException {
        String targetClassName = targetClass;
        if (FIELD_MAP.containsKey(targetClassName)) {
            return FIELD_MAP.get(targetClassName);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        LinkedHashSet members = new LinkedHashSet();
        LinkedList classesToProcess = new LinkedList();
        HashSet<Class> processedClasses = new HashSet<Class>();
        classesToProcess.add(Class.forName(targetClass));
        while (!classesToProcess.isEmpty()) {
            Class currentClass = (Class)classesToProcess.pop();
            String name = currentClass.getName();
            if (map.containsKey(name) || currentClass == null || processedClasses.contains(currentClass)) continue;
            processedClasses.add(currentClass);
            HashSet<String> sets = new HashSet<String>();
            List<String> list1 = Arrays.stream(currentClass.getFields()).map(field -> field.getName()).toList();
            sets.addAll(list1);
            map.put(name, Lists.newArrayList(sets));
            if (currentClass.getSuperclass() != null) {
                classesToProcess.add(currentClass.getSuperclass());
            }
            classesToProcess.addAll(Arrays.asList(currentClass.getInterfaces()));
        }
        FIELD_MAP.put(targetClassName, map);
        return map;
    }

    private static boolean isMinecraftClazz(String declaredClazz, BaseClazzCheckManager<?, ?> checkManager) {
        for (String s : checkManager.getMcGroups()) {
            if (!declaredClazz.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

