/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.ClassAnalysisResult;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.LogEntry;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.LogLevel;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.clazz.VerifyExistence;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.util.ModUtil;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.util.TimeUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;

public class MultiClassAnalysisResult {
    public static final Path ROOT_FOLDER = FMLPaths.GAMEDIR.get().resolve("logs");
    final List<ClassAnalysisResult> classResults = new ArrayList<ClassAnalysisResult>();
    final List<LogEntry> globalLogs = new ArrayList<LogEntry>();
    final Set<String> allClasses = new TreeSet<String>();
    final Set<String> allMethods = new TreeSet<String>();
    final Set<String> allFields = new TreeSet<String>();
    final Set<String> allMixins = new TreeSet<String>();

    public void addClassResult(ClassAnalysisResult result) {
        this.classResults.add(result);
        this.allClasses.addAll(result.classes);
        this.allMethods.addAll(result.methods);
        this.allFields.addAll(result.fields);
        this.allMixins.addAll(result.mixins);
        this.globalLogs.addAll(result.logs);
    }

    public static String getExportFileAbsPath(BaseClazzCheckManager<?, ?> checkManager) {
        return MultiClassAnalysisResult.getExportFilePath(checkManager).toString();
    }

    private static Path getExportFilePath(BaseClazzCheckManager<?, ?> checkManager) {
        return ROOT_FOLDER.resolve(checkManager.getModId() + "_task_clazz_analysis.txt");
    }

    public Path exportToFile(Map<String, VerifyExistence.ClazzInfo> allClazzInfo, BaseClazzCheckManager<?, ?> checkManager) throws IOException {
        File file = MultiClassAnalysisResult.getExportFilePath(checkManager).toFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(this.generateReport(allClazzInfo, checkManager));
        fileWriter.close();
        this.globalLogs.add(new LogEntry(LogLevel.INFO, "The task analysis report has been exported to: " + file.getPath()));
        return file.toPath();
    }

    private String generateReport(Map<String, VerifyExistence.ClazzInfo> allClazzInfo, BaseClazzCheckManager<?, ?> checkManager) {
        List list = this.classResults.stream().flatMap(a -> {
            ArrayList arrayList = Lists.newArrayList();
            a.classExistence.forEach((name, val) -> {
                if (!val.booleanValue()) {
                    arrayList.add(name);
                }
            });
            a.fieldExistence.forEach((name, val) -> {
                if (!val.booleanValue()) {
                    arrayList.add(name);
                }
            });
            a.methodExistence.forEach((name, val) -> {
                if (!val.booleanValue()) {
                    arrayList.add(name);
                }
            });
            a.mixinExistence.forEach((name, val) -> {
                if (!val.booleanValue()) {
                    arrayList.add(name);
                }
            });
            return arrayList.stream();
        }).toList();
        StringBuilder report = new StringBuilder();
        report.append("========= TaskAnalysisReport =========\n");
        report.append("Time: ").append(TimeUtil.getCurrentTimeWithFormat()).append("\n");
        report.append("GameVersion: ").append(FMLLoader.versionInfo().mcVersion()).append("\n");
        report.append("ModLoaderVersion: ").append(FMLLoader.versionInfo().forgeVersion()).append("\n");
        report.append(ModUtil.getModName(checkManager.getModId()).strip()).append("Version: ").append(ModUtil.getModVersion(checkManager.getModId())).append("\n");
        for (String mod : checkManager.getExtractMod()) {
            report.append(ModUtil.getModName(mod).strip()).append("Version: ").append(ModUtil.getModVersion(mod)).append("\n");
        }
        report.append("ModState: ").append(list.isEmpty() ? "[Success] Congratulations, there were no problems with this run, and we wish you a great time!" : "[Error] oops\uff0cThere are currently some mod compatibility failures, you can report to the author and bring this file with you to speed up the problem!").append("\n");
        if (!list.isEmpty()) {
            report.append("BugIssueUrl: ").append(checkManager.getIssueUrl()).append("\n");
        }
        report.append("ActualVersionWithCurrentCompatibleMod\uff1a").append("\n");
        for (String modId : checkManager.getCompatMods()) {
            String modVersion = ModUtil.getModVersion(modId);
            if (modVersion.isEmpty()) continue;
            report.append("- ").append(modId).append(": ").append(modVersion).append("\n");
        }
        report.append("\n");
        report.append("===== GlobalStatistics =====\n");
        report.append("ClassesCount: ").append(this.allClasses.size()).append("\n");
        report.append("MethodCount: ").append(this.allMethods.size()).append("\n");
        report.append("FieldCount: ").append(this.allFields.size()).append("\n");
        report.append("MixinCount: ").append(this.allMixins.size()).append("\n");
        report.append("Errors: ").append(list.size()).append("\n");
        for (String s : list) {
            report.append("- ").append(s).append("\n");
        }
        report.append("\n");
        report.append("===== TaskDetails =====\n\n");
        for (ClassAnalysisResult result : this.classResults) {
            report.append("## TaskId\uff1a ").append(result.uid).append("\u3001").append("ModId\uff1a ").append(result.modId).append("\u3001").append("ModVersion\uff1a ").append(result.version).append("\n");
            report.append("### ClassStatistics\n");
            report.append("ClassesCount: ").append(result.classes.size()).append("\n");
            report.append("MethodCount: ").append(result.methods.size()).append("\n");
            report.append("FieldCount: ").append(result.fields.size()).append("\n");
            report.append("MixinCount: ").append(result.mixins.size()).append("\n");
            ArrayList list0 = Lists.newArrayList();
            result.classExistence.forEach((name, val) -> {
                if (!val.booleanValue()) {
                    list0.add(name);
                }
            });
            result.fieldExistence.forEach((name, val) -> {
                if (!val.booleanValue()) {
                    list0.add(name);
                }
            });
            result.methodExistence.forEach((name, val) -> {
                if (!val.booleanValue()) {
                    list0.add(name);
                }
            });
            result.mixinExistence.forEach((name, val) -> {
                if (!val.booleanValue()) {
                    list0.add(name);
                }
            });
            report.append("Errors: ").append(list0.size()).append("\n");
            for (String s : list0) {
                report.append("- ").append(s).append("\n");
            }
            report.append("\n");
            report.append("#### ClassesList\n");
            if (result.classes.isEmpty()) {
                report.append("NoClassesFound\n");
            } else {
                result.classes.forEach(m -> {
                    boolean exists = result.classExistence.getOrDefault(m, false);
                    report.append(exists ? "[Success] " : "[Error] ").append((String)m).append("\n");
                });
            }
            report.append("\n");
            report.append("#### MethodsList \n");
            if (result.methods.isEmpty()) {
                report.append("NoMethodFound\n");
            } else {
                result.methods.forEach(m -> {
                    boolean exists = result.methodExistence.getOrDefault(m, false);
                    report.append(exists ? "[Success] " : "[Error] ").append((String)m).append("\n");
                });
            }
            report.append("\n");
            report.append("#### FieldList\n");
            if (result.fields.isEmpty()) {
                report.append("NoFieldsFound\n");
            } else {
                result.fields.forEach(f -> {
                    boolean exists = result.fieldExistence.getOrDefault(f, false);
                    report.append(exists ? "[Success] " : "[Error] ").append((String)f).append("\n");
                });
            }
            report.append("\n");
            report.append("#### MixinList\n");
            if (result.mixins.isEmpty()) {
                report.append("NoMixinsFound\n");
            } else {
                result.mixins.forEach(f -> {
                    boolean exists = result.mixinExistence.getOrDefault(f, false);
                    report.append(exists ? "[Success] " : "[Error] ").append((String)f).append("\n");
                });
            }
            report.append("\n");
            report.append("#### ClassAnalysisLogs\n");
            result.logs.forEach(log -> report.append(log).append("\n"));
            report.append("\n");
        }
        report.append("### AnalyzeLogsGlobally\n");
        this.globalLogs.forEach(log -> report.append(log).append("\n"));
        report.append("\n##ModList").append("\n");
        LoadingModList.get().getMods().forEach(modInfo -> {
            String modId = modInfo.getModId();
            String version = modInfo.getVersion().toString();
            report.append("- ").append(modId).append(": ").append(version).append("\n");
        });
        return report.toString();
    }
}

