/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.recipe.water;

import com.github.wallev.maidsoulkitchen.init.ModRecipes;
import com.google.gson.JsonObject;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@ParametersAreNullableByDefault
public class ConsumeWaterRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final ItemStack input;
    public final ItemStack result;
    public final Condition condition;

    public ConsumeWaterRecipe(ResourceLocation id, ItemStack input, ItemStack result, Condition condition) {
        this.id = id;
        this.input = input;
        this.result = result;
        this.condition = condition;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)1);
        ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.input}));
        return ingredients;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CONSUME_WATER_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.CONSUME_WATER_RECIPE;
    }

    public static enum Condition {
        SINGLE,
        MULTIPLE;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static Condition of(String name) {
            return Condition.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
    }

    public static class Serializer
    implements RecipeSerializer<ConsumeWaterRecipe> {
        public ConsumeWaterRecipe fromJson(ResourceLocation pRecipeId, JsonObject jsonObject) {
            ItemStack input = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"input"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            Condition condition = Condition.of(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"condition"));
            return new ConsumeWaterRecipe(pRecipeId, input, result, condition);
        }

        @Nullable
        public ConsumeWaterRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ItemStack input = pBuffer.m_130267_();
            ItemStack result = pBuffer.m_130267_();
            Condition condition = Condition.of(pBuffer.m_130277_());
            return new ConsumeWaterRecipe(pRecipeId, input, result, condition);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ConsumeWaterRecipe pRecipe) {
            pBuffer.m_130055_(pRecipe.input);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.m_130070_(pRecipe.condition.toString());
        }
    }
}

