/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.GatherResult;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.util.ItemStackUtil;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WaterFdPotCookRule<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final WaterFdPotCookRule INSTANCE = new WaterFdPotCookRule();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> WaterFdPotCookRule<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        boolean hasResult = cookBeBase.hasResult();
        if (canTakeResult && hasResult && hasOutputAvailableSlot) {
            return true;
        }
        boolean hasMeal = cookBeBase.hasMeal();
        ItemStack nowContainer = cookBeBase.getNowContainer();
        boolean hasContainer = !nowContainer.m_41619_();
        ItemStack needContainer = cookBeBase.getNeedContainer();
        if (hasMeal && hasOutputAvailableSlot && (hasContainer ? hasInputAvailableSlot && !needContainer.m_41619_() && cm.hasItem(needContainer) : !needContainer.m_41619_() && cm.hasItem(needContainer))) {
            return true;
        }
        boolean cookStateMatch = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasEnoughFluid = cookBeBase.hasFluid();
        boolean hasInputs = cookBeBase.hasInputs();
        boolean findFuel = false;
        if (!recMatch && !hasInputs && !hasMeal && cm.hasMaidRecs(cookBeBase) && cookStateMatch) {
            if (!hasEnoughFluid) {
                List<ItemStack> activeItemStacks = cookBeBase.getActiveItems();
                findFuel = cm.hasItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
                if (findFuel) {
                    return true;
                }
            } else {
                return true;
            }
            return true;
        }
        if (recMatch && cookStateMatch && !hasEnoughFluid) {
            if (!findFuel) {
                List<ItemStack> activeItemStacks = cookBeBase.getActiveItems();
                findFuel = cm.hasItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
            }
            if (findFuel) {
                return true;
            }
        }
        if (hasContainer && hasInputAvailableSlot && !hasInputs) {
            return true;
        }
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            return true;
        }
        return hasEnoughFluid && cookStateMatch && !recMatch && hasInputAvailableSlot;
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        List<ItemStack> activeItemStacks;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        ItemStack meal = cookBeBase.getMeal();
        ItemStack nowContainer = cookBeBase.getNowContainer();
        if (!meal.m_41619_()) {
            ItemStack needContainer;
            GatherResult outputAdditionItemResult;
            if (!nowContainer.m_41619_()) {
                cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            }
            if (!(outputAdditionItemResult = cm.getItem(needContainer = cookBeBase.getNeedContainer())).isFail()) {
                ItemStack itemStack2 = outputAdditionItemResult.queryItemStack();
                cookBeBase.insertContainer(itemStack2);
                cookBeBase.markChanged();
                outputAdditionItemResult.backItemStack(itemStack2);
            }
        }
        boolean canTakeResult = cookBeBase.canTakeResult();
        ItemStack result = cookBeBase.getResult();
        if (canTakeResult && !result.m_41619_() && hasOutputAvailableSlot) {
            cookBeBase.takeItem(result, (IItemHandler)outputInv);
            cookBeBase.awardExp();
            cookBeBase.markChanged();
        }
        boolean cookStateMatch = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasEnoughFluid = cookBeBase.hasFluid();
        boolean hasInputs = cookBeBase.hasInputs();
        GatherResult findFluidResult = GatherResult.FAIL;
        if (!recMatch && !hasInputs && meal.m_41619_() && cm.hasMaidRecs(cookBeBase)) {
            if (!cookStateMatch) {
                activeItemStacks = cookBeBase.getActiveItems();
                findFluidResult = cm.getItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
                if (!findFluidResult.isFail()) {
                    ItemInventory itemInventory = cm.getItemInventory();
                    cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
                    cookBeBase.markChanged();
                    recMatch = true;
                }
            } else {
                ItemInventory itemInventory = cm.getItemInventory();
                cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
                cookBeBase.markChanged();
                recMatch = true;
            }
        }
        if (recMatch && cookStateMatch && !hasEnoughFluid) {
            if (findFluidResult.isFail()) {
                activeItemStacks = cookBeBase.getActiveItems();
                findFluidResult = cm.getItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
            }
            if (!findFluidResult.isFail()) {
                ItemStack itemStack3 = findFluidResult.queryItemStack();
                cookBeBase.useItem(itemStack3, () -> !cookBeBase.hasFluid(), inputInv);
                cookBeBase.markChanged();
                findFluidResult.backItemStack(itemStack3);
            }
        }
        if (!nowContainer.m_41619_() && hasInputAvailableSlot && !hasInputs) {
            cookBeBase.takeItem(nowContainer, (IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
    }
}

