/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec;

import com.github.wallev.maidsoulkitchen.task.cook.common.inv.ingredient.RecIngredient;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class MKRecipe<R extends Recipe<? extends Container>> {
    protected final R rec;
    protected final boolean single;
    private final RecIngredient tool;
    protected final List<ItemStack> inFluids;
    protected final List<RecIngredient> inItems;
    protected final ItemStack output;
    protected final ItemStack container;
    protected final ResourceLocation id;
    protected Set<Item> validInItems;
    protected Set<Item> validInFluids;
    protected Set<ItemDefinition> validInItemDefinitions;
    protected Set<ItemDefinition> validInFluidDefinitions;

    public MKRecipe(R rec, boolean single, RecIngredient tool, List<ItemStack> inFluids, List<RecIngredient> inItems, ItemStack output, ItemStack container, Set<Item> validInItems, Set<Item> validInFluids) {
        this.rec = rec;
        this.single = single;
        this.tool = tool;
        this.inFluids = inFluids;
        this.inItems = inItems;
        this.output = output;
        this.container = container;
        this.id = rec.m_6423_();
        this.validInItems = validInItems;
        this.validInFluids = validInFluids;
        this.validInItemDefinitions = MKRecipe.createValidItemDefinitionsFromItems(validInItems);
        this.validInFluidDefinitions = MKRecipe.createValidItemDefinitionsFromItems(validInFluids);
    }

    public MKRecipe(R rec, boolean single, RecIngredient tool, List<ItemStack> inFluids, List<RecIngredient> inItems, ItemStack output, ItemStack container) {
        this.rec = rec;
        this.single = single;
        this.tool = tool;
        this.inFluids = inFluids;
        this.inItems = inItems;
        this.output = output;
        this.container = container;
        this.id = rec.m_6423_();
        this.validInItems = MKRecipe.createValidItemsFromIngredients(inItems);
        this.validInFluids = MKRecipe.createValidItemsFromItemStacks(inFluids);
        this.validInItemDefinitions = MKRecipe.createValidItemDefinitionsFromIngredients(inItems);
        this.validInFluidDefinitions = MKRecipe.createValidItemDefinitionsFromItemStacks(inFluids);
    }

    public MKRecipe(R rec, boolean single, RecIngredient tool, List<RecIngredient> inItems, ItemStack output, ItemStack container) {
        this(rec, single, tool, List.of(), inItems, output, container);
    }

    public MKRecipe(R rec, boolean single, RecIngredient tool, List<RecIngredient> inItems, ItemStack output) {
        this(rec, single, tool, List.of(), inItems, output, ItemStack.f_41583_);
    }

    public MKRecipe(R rec, boolean single, List<ItemStack> inFluids, List<RecIngredient> inItems, ItemStack output, ItemStack container) {
        this(rec, single, RecIngredient.EMPTY, inFluids, inItems, output, container, MKRecipe.createValidItemsFromIngredients(inItems), MKRecipe.createValidItemsFromItemStacks(inFluids));
    }

    public MKRecipe(R rec, boolean single, List<ItemStack> inFluids, List<RecIngredient> inItems, ItemStack output) {
        this(rec, single, inFluids, inItems, output, ItemStack.f_41583_);
    }

    public MKRecipe(R rec, boolean single, Set<Item> validInItems, List<RecIngredient> inItems, ItemStack output) {
        this(rec, single, RecIngredient.EMPTY, List.of(), inItems, output, ItemStack.f_41583_, validInItems, Set.of());
    }

    public MKRecipe(R rec, boolean single, List<RecIngredient> inItems, ItemStack output) {
        this(rec, single, List.of(), inItems, output, ItemStack.f_41583_);
    }

    public MKRecipe(R rec, boolean single, List<RecIngredient> inItems, ItemStack output, ItemStack container) {
        this(rec, single, List.of(), inItems, output, container);
    }

    public static Set<Item> createValidItemsFromIngredients(List<RecIngredient> items) {
        return items.stream().flatMap(RecIngredient2 -> Arrays.stream(RecIngredient2.ingredient.m_43908_())).map(ItemStack::m_41720_).collect(Collectors.toSet());
    }

    public static Set<Item> createValidItemsFromItemStacks(List<ItemStack> items) {
        return items.stream().map(ItemStack::m_41720_).collect(Collectors.toSet());
    }

    public static Set<ItemDefinition> createValidItemDefinitionsFromIngredients(List<RecIngredient> items) {
        return items.stream().flatMap(RecIngredient2 -> Arrays.stream(RecIngredient2.ingredient.m_43908_())).map(ItemDefinition::of).collect(Collectors.toSet());
    }

    public static Set<ItemDefinition> createValidItemDefinitionsFromItemStacks(List<ItemStack> items) {
        return items.stream().map(ItemDefinition::of).collect(Collectors.toSet());
    }

    public static Set<ItemDefinition> createValidItemDefinitionsFromItems(Set<Item> items) {
        return items.stream().map(ItemDefinition::of).collect(Collectors.toSet());
    }

    public RecIngredient tool() {
        return this.tool;
    }

    public List<ItemStack> inFluids() {
        return this.inFluids;
    }

    public List<RecIngredient> inItems() {
        return this.inItems;
    }

    public ItemStack output() {
        return this.output;
    }

    public ItemStack container() {
        return this.container;
    }

    public Set<Item> validInItems() {
        return this.validInItems;
    }

    public Set<Item> validInFluids() {
        return this.validInFluids;
    }

    public Set<ItemDefinition> validInItemDefinitions() {
        return this.validInItemDefinitions;
    }

    public Set<ItemDefinition> validInFluidDefinitions() {
        return this.validInFluidDefinitions;
    }

    public R rec() {
        return this.rec;
    }

    public boolean isSingle() {
        return this.single;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public String idStr() {
        return this.id().toString();
    }

    public String toString() {
        return this.id().toString();
    }
}

