/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.crokckpot.crockpot.rec;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMax;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMin;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.item.Item;

@TaskClassAnalyzer(value=TaskInfo.CP_CROCK_POT)
public class MKCrockPotRecipe
extends MKRecipe<CrockPotCookingRecipe> {
    protected List<Pair<RequirementCategoryMax, Set<Item>>> noRequires = new ArrayList<Pair<RequirementCategoryMax, Set<Item>>>();
    protected List<Pair<RequirementCategoryMax, Set<Item>>> maxRequires = new ArrayList<Pair<RequirementCategoryMax, Set<Item>>>();
    protected List<Pair<RequirementCategoryMaxExclusive, Set<Item>>> maxERequires = new ArrayList<Pair<RequirementCategoryMaxExclusive, Set<Item>>>();
    protected List<Pair<RequirementCategoryMinExclusive, Set<Item>>> anyRequires = new ArrayList<Pair<RequirementCategoryMinExclusive, Set<Item>>>();
    protected List<Pair<RequirementCategoryMinExclusive, Set<Item>>> minERequires = new ArrayList<Pair<RequirementCategoryMinExclusive, Set<Item>>>();
    protected List<Pair<RequirementCategoryMin, Set<Item>>> minRequires = new ArrayList<Pair<RequirementCategoryMin, Set<Item>>>();
    protected List<Pair<RequirementMustContainIngredient, Set<Item>>> mustRequires = new ArrayList<Pair<RequirementMustContainIngredient, Set<Item>>>();
    protected List<Pair<RequirementMustContainIngredientLessThan, Set<Item>>> mustLessRequires = new ArrayList<Pair<RequirementMustContainIngredientLessThan, Set<Item>>>();
    protected List<List<Pair<IRequirement, Set<Item>>>> needRequires = new ArrayList<List<Pair<IRequirement, Set<Item>>>>();
    protected List<ItemDefinition> noRequiresItemDefinitions = new ArrayList<ItemDefinition>();

    public MKCrockPotRecipe(CrockPotCookingRecipe rec, Map<IRequirement, List<Item>> REQUIREMENT_INGREDIENTY_MAP) {
        super(rec, false, Collections.emptyList(), rec.getResult());
        this.categorizeRequirements(REQUIREMENT_INGREDIENTY_MAP);
        this.validInItems = this.createValidItems();
        this.validInItemDefinitions = MKCrockPotRecipe.createValidItemDefinitionsFromItems(this.validInItems);
        this.needRequires = this.createNeedRequires();
        this.noRequiresItemDefinitions = this.createInValidItemDefinitionsFromItems();
    }

    private List<ItemDefinition> createInValidItemDefinitionsFromItems() {
        ArrayList<ItemDefinition> noRequiresItemDefinitions = new ArrayList<ItemDefinition>();
        for (Pair<RequirementCategoryMax, Set<Item>> noRequire : this.noRequires) {
            Set itemSet = (Set)noRequire.getSecond();
            Set<ItemDefinition> validItemDefinitionsFromItems = MKCrockPotRecipe.createValidItemDefinitionsFromItems(itemSet);
            noRequiresItemDefinitions.addAll(validItemDefinitionsFromItems);
        }
        return noRequiresItemDefinitions;
    }

    private List<List<Pair<IRequirement, Set<Item>>>> createNeedRequires() {
        ArrayList<List<Pair<IRequirement, Set<Item>>>> needRequires = new ArrayList<List<Pair<IRequirement, Set<Item>>>>();
        MKCrockPotRecipe.addRequirement(needRequires, this.anyRequires);
        MKCrockPotRecipe.addRequirement(needRequires, this.mustRequires);
        MKCrockPotRecipe.addRequirement(needRequires, this.minRequires);
        MKCrockPotRecipe.addRequirement(needRequires, this.minERequires);
        MKCrockPotRecipe.addRequirement(needRequires, this.maxRequires);
        MKCrockPotRecipe.addRequirement(needRequires, this.maxERequires);
        return needRequires;
    }

    private static <IR extends IRequirement> void addRequirement(List<List<Pair<IRequirement, Set<Item>>>> needRequires, List<Pair<IR, Set<Item>>> requirementItems) {
        if (!requirementItems.isEmpty()) {
            needRequires.add(requirementItems);
        }
    }

    private void categorizeRequirements(Map<IRequirement, List<Item>> REQUIREMENT_INGREDIENTY_MAP) {
        for (IRequirement requirement : ((CrockPotCookingRecipe)this.rec()).getRequirements()) {
            if (requirement instanceof RequirementCategoryMax) {
                RequirementCategoryMax requirementCategoryMax = (RequirementCategoryMax)requirement;
                if (MathUtils.fuzzyIsZero((float)requirementCategoryMax.getMax())) {
                    this.addNoRequirements((Pair<RequirementCategoryMax, Set<Item>>)Pair.of((Object)requirementCategoryMax, this.getQuireItemSet(REQUIREMENT_INGREDIENTY_MAP, (IRequirement)requirementCategoryMax)));
                    continue;
                }
                this.addMaxRequirements((Pair<RequirementCategoryMax, Set<Item>>)Pair.of((Object)requirementCategoryMax, this.getQuireItemSet(REQUIREMENT_INGREDIENTY_MAP, (IRequirement)requirementCategoryMax)));
                continue;
            }
            if (requirement instanceof RequirementCategoryMinExclusive) {
                RequirementCategoryMinExclusive requirementCategoryMinExclusive = (RequirementCategoryMinExclusive)requirement;
                if (MathUtils.fuzzyIsZero((float)requirementCategoryMinExclusive.getMin())) {
                    this.addAnyRequirements((Pair<RequirementCategoryMinExclusive, Set<Item>>)Pair.of((Object)requirementCategoryMinExclusive, this.getQuireItemSet(REQUIREMENT_INGREDIENTY_MAP, (IRequirement)requirementCategoryMinExclusive)));
                    continue;
                }
                this.addMinERequirements((Pair<RequirementCategoryMinExclusive, Set<Item>>)Pair.of((Object)requirementCategoryMinExclusive, this.getQuireItemSet(REQUIREMENT_INGREDIENTY_MAP, (IRequirement)requirementCategoryMinExclusive)));
                continue;
            }
            if (requirement instanceof RequirementCategoryMin) {
                RequirementCategoryMin requirementCategoryMin = (RequirementCategoryMin)requirement;
                this.addMinRequirements((Pair<RequirementCategoryMin, Set<Item>>)Pair.of((Object)requirementCategoryMin, this.getQuireItemSet(REQUIREMENT_INGREDIENTY_MAP, (IRequirement)requirementCategoryMin)));
                continue;
            }
            if (requirement instanceof RequirementCategoryMaxExclusive) {
                RequirementCategoryMaxExclusive requirementCategoryMaxE = (RequirementCategoryMaxExclusive)requirement;
                this.addMaxERequirements((Pair<RequirementCategoryMaxExclusive, Set<Item>>)Pair.of((Object)requirementCategoryMaxE, this.getQuireItemSet(REQUIREMENT_INGREDIENTY_MAP, (IRequirement)requirementCategoryMaxE)));
                continue;
            }
            if (requirement instanceof RequirementMustContainIngredient) {
                RequirementMustContainIngredient requirementMustContainIngredient = (RequirementMustContainIngredient)requirement;
                this.addMustRequirements((Pair<RequirementMustContainIngredient, Set<Item>>)Pair.of((Object)requirementMustContainIngredient, this.getQuireItemSet(REQUIREMENT_INGREDIENTY_MAP, (IRequirement)requirementMustContainIngredient)));
                continue;
            }
            if (!(requirement instanceof RequirementMustContainIngredientLessThan)) continue;
            RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan = (RequirementMustContainIngredientLessThan)requirement;
            this.addMustLessRequirements((Pair<RequirementMustContainIngredientLessThan, Set<Item>>)Pair.of((Object)requirementMustContainIngredientLessThan, this.getQuireItemSet(REQUIREMENT_INGREDIENTY_MAP, (IRequirement)requirementMustContainIngredientLessThan)));
        }
    }

    protected Set<Item> createValidItems() {
        HashSet validItems = Sets.newHashSet();
        for (Pair<RequirementCategoryMinExclusive, Set<Item>> pair : this.anyRequires) {
            validItems.addAll((Collection)pair.getSecond());
        }
        for (Pair<RequirementCategoryMinExclusive, Set<Item>> pair : this.mustRequires) {
            validItems.addAll((Collection)pair.getSecond());
        }
        for (Pair<RequirementCategoryMinExclusive, Set<Item>> pair : this.maxRequires) {
            validItems.addAll((Collection)pair.getSecond());
        }
        for (Pair<RequirementCategoryMinExclusive, Set<Item>> pair : this.maxERequires) {
            validItems.addAll((Collection)pair.getSecond());
        }
        for (Pair<RequirementCategoryMinExclusive, Set<Item>> pair : this.minERequires) {
            validItems.addAll((Collection)pair.getSecond());
        }
        for (Pair<RequirementCategoryMinExclusive, Set<Item>> pair : this.minRequires) {
            validItems.addAll((Collection)pair.getSecond());
        }
        for (Pair<RequirementCategoryMinExclusive, Set<Item>> pair : this.mustLessRequires) {
            validItems.addAll((Collection)pair.getSecond());
        }
        for (Pair<RequirementCategoryMinExclusive, Set<Item>> pair : this.noRequires) {
            validItems.removeAll((Collection)pair.getSecond());
        }
        return validItems;
    }

    private Set<Item> getQuireItemSet(Map<IRequirement, List<Item>> REQUIREMENT_INGREDIENTY_MAP, IRequirement requirement) {
        return new HashSet<Item>(this.getQuireItems(REQUIREMENT_INGREDIENTY_MAP, requirement));
    }

    private List<Item> getQuireItems(Map<IRequirement, List<Item>> REQUIREMENT_INGREDIENTY_MAP, IRequirement requirement) {
        return REQUIREMENT_INGREDIENTY_MAP.get(requirement);
    }

    private void addNoRequirements(Pair<RequirementCategoryMax, Set<Item>> requirementItems) {
        this.noRequires.add(requirementItems);
    }

    private void addMaxRequirements(Pair<RequirementCategoryMax, Set<Item>> requirementItems) {
        this.maxRequires.add(requirementItems);
    }

    private void addMaxERequirements(Pair<RequirementCategoryMaxExclusive, Set<Item>> requirementItems) {
        this.maxERequires.add(requirementItems);
    }

    private void addAnyRequirements(Pair<RequirementCategoryMinExclusive, Set<Item>> requirementItems) {
        this.anyRequires.add(requirementItems);
    }

    private void addMinERequirements(Pair<RequirementCategoryMinExclusive, Set<Item>> requirementItems) {
        this.minERequires.add(requirementItems);
    }

    private void addMinRequirements(Pair<RequirementCategoryMin, Set<Item>> requirementItems) {
        this.minRequires.add(requirementItems);
    }

    private void addMustRequirements(Pair<RequirementMustContainIngredient, Set<Item>> requirementItems) {
        this.mustRequires.add(requirementItems);
    }

    private void addMustLessRequirements(Pair<RequirementMustContainIngredientLessThan, Set<Item>> requirementItems) {
        this.mustLessRequires.add(requirementItems);
    }

    public List<Pair<RequirementCategoryMax, Set<Item>>> getNoRequires() {
        return this.noRequires;
    }

    public List<Pair<RequirementCategoryMax, Set<Item>>> getMaxRequires() {
        return this.maxRequires;
    }

    public List<Pair<RequirementCategoryMaxExclusive, Set<Item>>> getMaxERequires() {
        return this.maxERequires;
    }

    public List<Pair<RequirementCategoryMinExclusive, Set<Item>>> getAnyRequires() {
        return this.anyRequires;
    }

    public List<Pair<RequirementCategoryMinExclusive, Set<Item>>> getMinERequires() {
        return this.minERequires;
    }

    public List<Pair<RequirementCategoryMin, Set<Item>>> getMinRequires() {
        return this.minRequires;
    }

    public List<Pair<RequirementMustContainIngredient, Set<Item>>> getMustRequires() {
        return this.mustRequires;
    }

    public List<Pair<RequirementMustContainIngredientLessThan, Set<Item>>> getMustLessRequires() {
        return this.mustLessRequires;
    }

    public List<List<Pair<IRequirement, Set<Item>>>> getNeedRequires() {
        return this.needRequires;
    }

    public List<ItemDefinition> getNoRequiresItemDefinitions() {
        return this.noRequiresItemDefinitions;
    }
}

