/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemStackUtil {
    private static Map<Item, ItemStack> CACHE;
    private static List<ItemStack> DEFAULT_FUELS;

    private ItemStackUtil() {
    }

    public static void init() {
    }

    public static ItemStack getItemStack(Item item) {
        return CACHE.computeIfAbsent(item, ItemStack::new);
    }

    public static boolean isItem(List<ItemStack> itemStacks, Item item) {
        for (ItemStack itemStack : itemStacks) {
            if (!itemStack.m_150930_(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItem(List<ItemStack> itemStacks, ItemStack itemStack) {
        return ItemStackUtil.isItem(itemStacks, itemStack.m_41720_());
    }

    public static ItemStack item2Inv(ItemStack itemStack, IItemHandler inv) {
        ItemStack copy = itemStack.m_41777_();
        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)copy, (boolean)false);
        itemStack.m_41774_(copy.m_41613_() - leftStack.m_41613_());
        return itemStack;
    }

    public static List<ItemStack> getDefaultFuels() {
        if (DEFAULT_FUELS == null) {
            int lastBurnTime = 0;
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            for (Item value : ForgeRegistries.ITEMS.getValues()) {
                ItemStack itemStack = value.m_7968_();
                int burnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
                if (burnTime <= 0) continue;
                if (burnTime > lastBurnTime) {
                    fuels.add(0, itemStack);
                } else {
                    fuels.add(itemStack);
                }
                lastBurnTime = burnTime;
            }
            DEFAULT_FUELS = fuels;
        }
        return DEFAULT_FUELS;
    }

    public static List<ItemStack> getFurnaceFuels() {
        int lastBurnTime = 0;
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
        for (Item value : ForgeRegistries.ITEMS.getValues()) {
            ItemStack itemStack = value.m_7968_();
            int burnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
            if (burnTime <= 0) continue;
            if (burnTime > lastBurnTime) {
                fuels.add(0, itemStack);
            } else {
                fuels.add(itemStack);
            }
            lastBurnTime = burnTime;
        }
        return fuels;
    }

    static {
        HashMap<Item, ItemStack> cache = new HashMap<Item, ItemStack>();
        for (Item value : ForgeRegistries.ITEMS.getValues()) {
            try {
                ItemStack itemStack = value.m_7968_();
                cache.put(value, itemStack);
            }
            catch (RuntimeException e) {
                MaidsoulKitchen.LOGGER.error("error item: {}", (Object)value);
                e.printStackTrace();
            }
        }
        CACHE = cache;
    }
}

