/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.nbtcustom;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.ICookingGuideGenerator;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.CraftGuideOperator2;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import studio.fantasyit.maid_storage_manager.craft.CollectCraftEvent;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.IngredientNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.ItemNode;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.Node;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.node.SpecialCraftNode;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public abstract class INbtCookingGuideGenerator
implements ICookingGuideGenerator<ItemStack> {
    private UUID FROM_INGREDIENT_UUID = UUID.randomUUID();

    public INbtCookingGuideGenerator(CollectCraftEvent event) {
        event.addAutoCraftGuideGenerator((IAutoCraftGuideGenerator)this);
        Item nbtItemStackItem = this.getNbtItemStackItem();
        event.addItemStackPredicate(nbtItemStackItem, (stack, target) -> {
            if (!stack.m_150930_(nbtItemStackItem)) {
                return false;
            }
            if (!target.m_150930_(nbtItemStackItem)) {
                return false;
            }
            return this.isSameItemStack((ItemStack)stack, (ItemStack)target);
        });
    }

    public abstract boolean isSameItemStack(ItemStack var1, ItemStack var2);

    public abstract Item getNbtItemStackItem();

    public abstract Ingredient getAllIngredient();

    @Override
    public int getRecipeTime(ItemStack recipe) {
        return 0;
    }

    public Ingredient createAllIngredient(Predicate<Item> predicate) {
        Stream<ItemStack> itemStream = ForgeRegistries.ITEMS.getValues().stream().filter(predicate).map(Item::m_7968_);
        return Ingredient.m_43921_(itemStream);
    }

    @Override
    public boolean isValidBlockInWorld(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        return this.isValidGroundBlock((Level)level, pos);
    }

    @Override
    public void generate(final List<InventoryItem> inventory, final Level level, final BlockPos pos, ICachableGeneratorGraph graph, final Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        final StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn((Level)level, (BlockPos)pos);
        graph.addSpecialCraftNode(id -> new SpecialCraftNode((int)id){

            public void buildGraph(ICachableGeneratorGraph graph) {
                for (Node node : graph.getNodes()) {
                    if (!(node instanceof ItemNode)) continue;
                    ItemNode in = (ItemNode)node;
                    ItemStack itemStack = in.itemStack;
                    if (!itemStack.m_150930_(INbtCookingGuideGenerator.this.getNbtItemStackItem())) continue;
                    ItemNode itemNodeOrCreate = graph.getItemNodeOrCreate(itemStack, false);
                    this.addEdge((Node)itemNodeOrCreate, 1);
                }
                Ingredient ingredient = INbtCookingGuideGenerator.this.getAllIngredient();
                IngredientNode ingredientNode = graph.addOrGetCahcedIngredientNode(ingredient, INbtCookingGuideGenerator.this.FROM_INGREDIENT_UUID);
                ingredientNode.addEdge((Node)this, 1);
                graph.addToQueue((Node)this);
            }

            public void generate(ICachableGeneratorGraph graph) {
                for (Node node : graph.getNodes()) {
                    ItemStack cakeRoll;
                    if (!(node instanceof ItemNode)) continue;
                    ItemNode in = (ItemNode)node;
                    if (!in.itemStack.m_150930_(INbtCookingGuideGenerator.this.getNbtItemStackItem()) || !posFilter.isAvailable(cakeRoll = in.itemStack) || !graph.getItemNodeOrCreate((ItemStack)cakeRoll, (boolean)false).related) continue;
                    List<ItemStack> ingredients = INbtCookingGuideGenerator.this.getInputsWithItemStack(cakeRoll);
                    CraftGuideOperator2 craftGuide = CraftGuideOperator2.create(pos);
                    INbtCookingGuideGenerator.this.generateStep(inventory, level, pos, graph, recognizedTypePositions, craftGuide, INbtCookingGuideGenerator.this.getOutputs(cakeRoll, level.m_9598_()), ingredients);
                    CraftGuideData craftGuideData = craftGuide.makeCraftGuideData();
                    graph.addCraftGuide(craftGuideData);
                }
            }

            public String toString() {
                return "SpecialNode:" + INbtCookingGuideGenerator.this.getType().toString().toLowerCase(Locale.ENGLISH) + "#" + this.id;
            }
        });
    }

    public abstract void generateStep(List<InventoryItem> var1, Level var2, BlockPos var3, ICachableGeneratorGraph var4, Map<ResourceLocation, List<BlockPos>> var5, CraftGuideOperator2 var6, List<ItemStack> var7, List<ItemStack> var8);

    public boolean isBlockValid(Level level, BlockPos pos) {
        return true;
    }

    @Override
    public void consumeRecipes(RecipeManager manager, Consumer<ItemStack> recipeConsumer) {
    }

    @Override
    public void onCache(RecipeManager manager) {
        Ingredient ingredient = this.getAllIngredient();
        this.FROM_INGREDIENT_UUID = RecipeIngredientCache.cacheIngredient((Ingredient)ingredient);
    }

    @Override
    public ResourceLocation getRecipeId(ItemStack recipe) {
        return null;
    }

    @Override
    public List<Ingredient> getInputs(ItemStack recipe) {
        return List.of();
    }

    public abstract List<ItemStack> getInputsWithItemStack(ItemStack var1);

    @Override
    public abstract List<ItemStack> getOutputs(ItemStack var1, RegistryAccess var2);

    @Override
    public boolean shouldCacheRecipe(ItemStack recipe) {
        return false;
    }
}

