/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.tea;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.click.IOnlyUseGuideGenerator;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.base.EnchantCommonUseAction;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.FailCraftGuideStepData;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.CraftGuideOperator2;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.action.TargetUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOption;
import studio.fantasyit.maid_storage_manager.craft.action.ActionOptionSet;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;

public interface ITeaGuideGenerator<R extends Recipe<? extends Container>>
extends IOnlyUseGuideGenerator<R> {
    @Override
    default public void generateSteps(BlockPos pos, Level level, R recipe, CraftGuideOperator2 craftGuide, List<ItemStack> realItems, boolean needContainer, List<ItemStack> containers, List<ItemStack> outputs, List<ItemStack> remains) {
        ItemStack cup = realItems.remove(0);
        ItemStack liquid = realItems.remove(realItems.size() - 1);
        craftGuide.addItemUse(cup);
        CraftGuideOperator2.forEachSingleItem(realItems, itemStack -> craftGuide.addItemUse(pos.m_7494_(), (ItemStack)itemStack));
        ItemStack leftFluidTeaBase = this.leftFluidTeaBase(liquid.m_255036_(1));
        ArrayList<CraftGuideStepData> failSteps = new ArrayList<CraftGuideStepData>();
        CraftGuideStepData failCupStep = new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos.m_7494_()), List.of(), List.of(liquid), CommonUseAction.TYPE, ActionOptionSet.with((ActionOption)ActionOption.OPTIONAL, (Object)true));
        failSteps.add(failCupStep);
        CraftGuideOperator2.forEachSingleItem(realItems, itemStack -> {
            CraftGuideStepData failLeaveStep = new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos.m_7494_()), List.of(), List.of(itemStack), CommonUseAction.TYPE);
            failSteps.add(failLeaveStep);
        });
        CompoundTag compoundTag = FailCraftGuideStepData.toCompoundTag(failSteps);
        CraftGuideStepData resultStepData = new CraftGuideStepData(TargetUtil.makeTargetVirtualNoSide(pos.m_7494_()), List.of(liquid), List.of(leftFluidTeaBase), EnchantCommonUseAction.TYPE, compoundTag);
        craftGuide.addStep(resultStepData);
        craftGuide.addEmptyUse(pos.m_7494_(), outputs);
    }

    @Override
    default public List<Ingredient> getInputs(R recipe) {
        ArrayList inputs = Lists.newArrayList();
        inputs.addAll(this.getCups(recipe));
        inputs.addAll(this.getTeaLeaves(recipe));
        inputs.addAll(this.getFluidTeaBase(recipe));
        return inputs;
    }

    @Override
    default public List<ItemStack> getOutputs(R recipe, RegistryAccess registryAccess) {
        return this.getTea(recipe, registryAccess);
    }

    public ItemStack leftFluidTeaBase(ItemStack var1);

    public List<Ingredient> getCups(R var1);

    public List<Ingredient> getTeaLeaves(R var1);

    public List<Ingredient> getFluidTeaBase(R var1);

    public List<ItemStack> getTea(R var1, RegistryAccess var2);

    @Override
    default public int getRecipeTime(R recipe) {
        return 0;
    }

    @Override
    default public boolean isValidBlockInWorld(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        return true;
    }

    default public boolean isBlockValid(Level level, BlockPos pos) {
        return this.isValidGroundBlock(level, pos);
    }
}

