/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.craft.custom;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.compat.msm.common.craft.util.IFailGuideUseActionContext;
import com.github.wallev.maidsoulkitchen.compat.msm.common.inv.IInvHandlerFactory;
import com.github.wallev.maidsoulkitchen.compat.msm.common.inv.InvHandlersHelper;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.inv.IInvHandler;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;

public class FailTakeAction
extends CommonTakeItemAction
implements IFailGuideUseActionContext {
    public static final ResourceLocation TYPE = VResourceLocation.createMod("fail_take");
    private TakerInteractHelper takerInteractHelper;

    public FailTakeAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    public AbstractCraftActionContext.Result start() {
        AbstractCraftActionContext.Result start = super.start();
        if (start != AbstractCraftActionContext.Result.FAIL) {
            this.takerInteractHelper = new TakerInteractHelper(this.craftGuideStepData.getStorage().pos, this.craftGuideStepData.getStorage().side, (ServerLevel)this.maid.f_19853_);
        }
        return start;
    }

    public AbstractCraftActionContext.Result tick() {
        return this.take();
    }

    public AbstractCraftActionContext.Result take() {
        Function<ItemStack, ItemStack> taker = itemStack -> {
            int toTakeCount = itemStack.m_41613_();
            ItemStack takenItem = itemStack.m_255036_(toTakeCount);
            ItemStack itemStack1 = InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), (ItemStack)takenItem);
            takenItem.m_41774_(itemStack1.m_41613_());
            return itemStack.m_255036_(itemStack.m_41613_() - takenItem.m_41613_());
        };
        this.takerInteractHelper.takeItemTick(taker);
        return AbstractCraftActionContext.Result.SUCCESS;
    }

    public static class TakerInteractHelper {
        public final BlockPos target;
        final ServerLevel level;
        @Nullable
        final BlockEntity blockEntity;
        @Nullable
        public IInvHandler iInvHandler;
        int currentSlot = 0;
        int countPreTick = 10;

        public TakerInteractHelper(BlockPos targetPos, @Nullable Direction side, ServerLevel level) {
            this.target = targetPos;
            this.level = level;
            this.blockEntity = level.m_7702_(this.target);
            if (this.blockEntity != null) {
                BlockEntityType type = this.blockEntity.m_58903_();
                IInvHandlerFactory<?> invHandlerFactory = InvHandlersHelper.get(type);
                if (invHandlerFactory != null) {
                    this.iInvHandler = invHandlerFactory.createInv(this.blockEntity, side);
                    if (this.iInvHandler.kl$getSlots() > 60) {
                        this.countPreTick = this.iInvHandler.kl$getSlots() / 6;
                    }
                } else {
                    this.iInvHandler = (IInvHandler)this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side).orElse(null);
                    if (this.iInvHandler != null && this.iInvHandler.kl$getSlots() > 60) {
                        this.countPreTick = this.iInvHandler.kl$getSlots() / 6;
                    }
                }
            }
        }

        protected boolean isStillValid() {
            if (this.blockEntity == null || this.iInvHandler == null) {
                return false;
            }
            return !this.blockEntity.m_58901_();
        }

        public void takeItemTick(Function<ItemStack, ItemStack> cb) {
            if (this.iInvHandler == null) {
                return;
            }
            while (this.currentSlot < this.iInvHandler.kl$getSlots()) {
                ItemStack result;
                ItemStack copy = this.iInvHandler.kl$extractItem(this.currentSlot, this.iInvHandler.kl$getStackInSlot(this.currentSlot).m_41613_(), true).m_41777_();
                int originalCount = copy.m_41613_();
                if (!copy.m_41619_() && (result = cb.apply(copy)).m_41613_() != originalCount) {
                    this.iInvHandler.kl$extractItem(this.currentSlot, originalCount - result.m_41613_(), false);
                }
                ++this.currentSlot;
            }
        }
    }
}

