/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.util.lang;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.github.wallev.maidsoulkitchen.compat.msm.common.autocraftguide.base.ICookingGuideGenerator;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.lang.ModLang;
import com.github.wallev.maidsoulkitchen.compat.msm.common.util.lang.TypeLang;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.util.AnnotationHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fml.loading.LoadingModList;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import studio.fantasyit.maid_storage_manager.craft.CollectCraftEvent;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;

public class MsmLangUtil {
    private static final Marker MARKER = MarkerManager.getMarker((String)"AutoGenLang");

    public static Map<String, String> getLangValues(Path resource) throws IOException {
        String json = Files.readString(resource);
        JsonObject jsonData = JsonParser.parseString((String)json).getAsJsonObject();
        Map<String, String> langVals = jsonData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).getAsString()));
        return langVals;
    }

    public static Path getResource(String modId, String path) {
        Path resource = LoadingModList.get().getModFileById(modId).getFile().findResource(new String[]{path});
        return resource;
    }

    private static CollectCraftEvent virtualEvent() {
        return new CollectCraftEvent(new ArrayList(), new ArrayList(), new ArrayList(), new HashMap());
    }

    private static void genModRecipeCompatLang(LanguageProvider languageProvider, String local) throws IOException {
        AnnotationHelper.read(TypeLang.class, data -> {
            Class<?> asmClazz;
            String lang = (String)AnnotationHelper.getHolderValue(data, local);
            CollectCraftEvent virtualEvent = MsmLangUtil.virtualEvent();
            String clazzName = data.clazz().getClassName();
            try {
                asmClazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            ICookingGuideGenerator<?> eventConstructor = MsmLangUtil.tryInstantiateWithEventConstructor(asmClazz, virtualEvent, languageProvider, lang);
            if (eventConstructor == null) {
                eventConstructor = MsmLangUtil.tryInstantiateEmptyConstructor(asmClazz, virtualEvent, languageProvider, lang);
            }
            switch (data.targetType()) {
                case METHOD: {
                    String key = eventConstructor.getTranslateKey();
                    MaidsoulKitchen.LOGGER.debug(MARKER, "auto gen method_lang: clazz: {}, key: {}", eventConstructor, (Object)key);
                    languageProvider.add(key, lang);
                    break;
                }
                case FIELD: {
                    String memberName = data.memberName();
                    Field annotatedField = AnnotationHelper.getAnnotatedField(asmClazz, memberName);
                    try {
                        Object o = annotatedField.get(eventConstructor);
                        if (!(o instanceof ConfigTypes.ConfigType)) break;
                        ConfigTypes.ConfigType configType = (ConfigTypes.ConfigType)o;
                        String transKey = MsmLangUtil.getTransKey(configType.getTranslatableName());
                        MaidsoulKitchen.LOGGER.debug(MARKER, "auto gen field_lang: clazz: {}, key: {}", eventConstructor, (Object)transKey);
                        languageProvider.add(transKey, lang);
                        break;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    @Nullable
    private static ICookingGuideGenerator<?> tryInstantiateWithEventConstructor(Class<?> clazz, CollectCraftEvent event, LanguageProvider languageProvider, String lang) {
        try {
            Constructor<?> constructor = clazz.getConstructor(CollectCraftEvent.class);
            ICookingGuideGenerator instance = (ICookingGuideGenerator)constructor.newInstance(event);
            return instance;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            MaidsoulKitchen.LOGGER.error(MARKER, "Failed to add auto_craft_guides instance: {}", clazz, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static ICookingGuideGenerator<?> tryInstantiateEmptyConstructor(Class<?> clazz, CollectCraftEvent event, LanguageProvider languageProvider, String lang) {
        try {
            ICookingGuideGenerator instance = (ICookingGuideGenerator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            event.addAutoCraftGuideGenerator((IAutoCraftGuideGenerator)instance);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
            MaidsoulKitchen.LOGGER.error(MARKER, "Failed to add auto_craft_guides instance: {}", clazz, (Object)ignored);
            throw new RuntimeException(ignored);
        }
    }

    private static void genModCompatLang(LanguageProvider languageProvider, String local) throws IOException {
        AnnotationHelper.read(ModLang.class, data -> {
            String value = AnnotationHelper.getEnumHolderValue(data, "value");
            String modId = Mods.by(value.toUpperCase(Locale.ENGLISH)).getModId();
            boolean custom = Optional.ofNullable(AnnotationHelper.getHolderValue(data, "custom")).orElse(false);
            if (custom) {
                String key1 = String.format("config.maid_storage_manager.crafting.generating.%s_%s", "maidsoulkitchen", modId);
                String val = (String)Optional.ofNullable(AnnotationHelper.getHolderValue(data, local)).orElse(AnnotationHelper.getHolderValue(data, "en_us"));
                languageProvider.add(key1, val);
                return;
            }
            String className = data.clazz().getClassName();
            String fieldName = data.memberName();
            Field annotatedField = AnnotationHelper.getAnnotatedField(className, fieldName);
            try {
                MutableComponent mutableComponent;
                ComponentContents patt8075$temp;
                LangProvider langSup;
                Component component;
                Object fieldValue = annotatedField.get(null);
                if (fieldValue instanceof LangProvider && (component = (langSup = (LangProvider)fieldValue).provider()) instanceof MutableComponent && (patt8075$temp = (mutableComponent = (MutableComponent)component).m_214077_()) instanceof TranslatableContents) {
                    String key;
                    TranslatableContents translatableContents = (TranslatableContents)patt8075$temp;
                    Path resource = MsmLangUtil.getResource(modId, String.format("assets/%s/lang/%s.json", modId, local));
                    if (resource == null) {
                        return;
                    }
                    Map<String, String> langValues = MsmLangUtil.getLangValues(resource);
                    String val = langValues.get(key = translatableContents.m_237508_());
                    if (val != null) {
                        String key1 = String.format("config.maid_storage_manager.crafting.generating.%s_%s", "maidsoulkitchen", modId);
                        languageProvider.add(key1, val);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("[AutoGenMatchNbtUseTag]Exception: " + className + "#" + fieldName, e);
            }
        });
    }

    public static String getTransKey(Component component) {
        MutableComponent mutableComponent;
        ComponentContents componentContents;
        if (component instanceof MutableComponent && (componentContents = (mutableComponent = (MutableComponent)component).m_214077_()) instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            return translatableContents.m_237508_();
        }
        return "";
    }

    public static void autonGenModLang(LanguageProvider languageProvider, String local) throws IOException {
        MsmLangUtil.genModCompatLang(languageProvider, local);
        MsmLangUtil.genModRecipeCompatLang(languageProvider, local);
    }

    public static interface LangProvider {
        public Component provider();
    }
}

