/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.datagen.recipe.water;

import com.github.wallev.maidsoulkitchen.init.ModRecipes;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.IMods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.recipe.water.ConsumeWaterRecipe;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ConsumeWaterRecipeBuilder
implements RecipeBuilder {
    private ConsumeWaterRecipe.Condition type = ConsumeWaterRecipe.Condition.SINGLE;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private ItemStack input = ItemStack.f_41583_;
    private ItemStack result = ItemStack.f_41583_;
    private final Set<String> modIds = new HashSet<String>();

    public static ConsumeWaterRecipeBuilder builder() {
        return new ConsumeWaterRecipeBuilder();
    }

    public ConsumeWaterRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public ConsumeWaterRecipeBuilder addModRecipe(IMods mod) {
        if (this.modIds.contains(mod.modId())) {
            return this;
        }
        return this.addModRecipe(mod.modId());
    }

    public ConsumeWaterRecipeBuilder addModRecipe(String modId) {
        if (this.modIds.contains(modId)) {
            return this;
        }
        this.modIds.add(modId);
        return this.addCondition((ICondition)new ModLoadedCondition(modId));
    }

    public ConsumeWaterRecipeBuilder setType(ConsumeWaterRecipe.Condition type) {
        this.type = type;
        return this;
    }

    public ConsumeWaterRecipeBuilder setInput(ItemStack stack) {
        this.input = stack;
        return this;
    }

    public ConsumeWaterRecipeBuilder setInput(ItemLike itemLike) {
        this.input = new ItemStack(itemLike);
        return this;
    }

    public ConsumeWaterRecipeBuilder setInput(ItemLike itemLike, int count) {
        this.input = new ItemStack(itemLike, count);
        return this;
    }

    public ConsumeWaterRecipeBuilder setResult(ItemStack stack) {
        this.result = stack;
        return this;
    }

    public ConsumeWaterRecipeBuilder setResult(ItemLike itemLike) {
        this.result = new ItemStack(itemLike);
        return this;
    }

    public ConsumeWaterRecipeBuilder setResult(ItemLike itemLike, int count) {
        this.result = new ItemStack(itemLike, count);
        return this;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_176498_(Consumer<FinishedRecipe> output) {
        this.checkModRecipe();
        String path = RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_135815_();
        ResourceLocation filePath = new ResourceLocation("maidsoulkitchen", this.type.toString() + "_water/" + path);
        this.m_126140_(output, filePath);
    }

    public void m_176500_(Consumer<FinishedRecipe> output, String recipeId) {
        this.checkModRecipe();
        ResourceLocation filePath = new ResourceLocation("maidsoulkitchen", this.type.toString() + "_water/" + recipeId);
        this.m_126140_(output, filePath);
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeOutput, ResourceLocation id) {
        this.checkModRecipe();
        recipeOutput.accept(new GetterWaterRecipe(this.type, id, this.input, this.result, this.conditions));
    }

    public void checkModRecipe() {
        ArrayList allItems = Lists.newArrayList();
        allItems.add(this.input);
        allItems.add(this.result);
        allItems.forEach(itemStack -> {
            String itemModId = itemStack.m_41720_().getCreatorModId(itemStack);
            if (itemModId == null) {
                return;
            }
            if (itemModId.equals(Mods.MC.modId())) {
                return;
            }
            if (itemModId.equals(Mods.MSK.modId())) {
                return;
            }
            if (this.modIds.contains(itemModId)) {
                return;
            }
            this.addModRecipe(itemModId);
        });
    }

    public record GetterWaterRecipe(ConsumeWaterRecipe.Condition type, ResourceLocation id, ItemStack input, ItemStack result, List<ICondition> conditions) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            if (!this.conditions.isEmpty()) {
                JsonArray conditionsJson = CraftingHelper.serialize((ICondition[])this.conditions.toArray(new ICondition[0]));
                json.add("conditions", (JsonElement)conditionsJson);
            }
            json.addProperty("condition", this.type.toString());
            JsonObject inputJson = new JsonObject();
            inputJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.input.m_41720_())).toString());
            CompoundTag inputTag = this.input.m_41783_();
            if (inputTag != null) {
                String string = inputTag.toString();
                inputJson.addProperty("nbt", string);
            }
            json.add("input", (JsonElement)inputJson);
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_())).toString());
            CompoundTag outputTag = this.result.m_41783_();
            if (outputTag != null) {
                String string = outputTag.toString();
                resultJson.addProperty("nbt", string);
            }
            json.add("result", (JsonElement)resultJson);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.CONSUME_WATER_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

