/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1;

import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.CookDataV1;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public class KitchenData {
    public static final Codec<Map<ResourceLocation, CookDataV1>> MAP_CODEC = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, CookDataV1.CODEC).xmap(HashMap::new, Function.identity());
    public static final Codec<KitchenData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MAP_CODEC.fieldOf("type_data").forGetter(kitchenData -> kitchenData.cookData), (App)ResourceLocation.f_135803_.fieldOf("kitchen_name").forGetter(kitchenData -> kitchenData.cookName)).apply((Applicative)instance, KitchenData::new));
    private final Map<ResourceLocation, CookDataV1> cookData;
    private ResourceLocation cookName;

    public KitchenData(Map<ResourceLocation, CookDataV1> cookData, ResourceLocation cookName) {
        this.cookData = cookData;
        this.cookName = cookName;
    }

    public KitchenData() {
        this(new HashMap<ResourceLocation, CookDataV1>(), TaskInfo.IDLE.getUid());
    }

    public ResourceLocation getCookName() {
        return this.cookName;
    }

    public void setCookName(ResourceLocation cookName) {
        this.cookName = cookName;
    }

    public Map<ResourceLocation, CookDataV1> getCookDatas() {
        return this.cookData;
    }

    public CookDataV1 getCookData(ResourceLocation name) {
        if (!this.cookData.containsKey(name)) {
            this.cookData.put(name, new CookDataV1());
        }
        return this.cookData.get(name);
    }

    public CookDataV1 getCookData() {
        return this.cookData.getOrDefault(this.cookName, new CookDataV1());
    }

    public void setCookData(ResourceLocation name, CookDataV1 cookData) {
        this.cookData.put(name, cookData);
    }
}

