/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.manager;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.IMods;
import com.github.wallev.maidsoulkitchen.util.ModUtil;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Mods implements IMods
{
    TLM("touhou_little_maid"),
    TLM_SLOT_MODERN("touhou_little_maid", "[1.4.2,)"),
    TLM_SLOT_LEGACY("touhou_little_maid", "[,1.4.2)"),
    MSK("maidsoulkitchen"),
    PATCHOULI("patchouli"),
    CLOTH_CONFIG("cloth_config"),
    JADE("jade"),
    TOP("theoneprobe"),
    SOPHISTICATED_STORAGE("sophisticatedstorage"),
    MAID_STORAGE_MANAGER("maid_storage_manager", "[1.13.7,)"),
    FD("farmersdelight"),
    MD("miners_delight"),
    MND("mynethersdelight"),
    CD("cuisinedelight"),
    BD("barbequesdelight"),
    YHCD_LEGACY("youkaishomecoming", "[2.2.3,2.3.13)"),
    YHCD_NEW("youkaishomecoming", "[2.3.13,)"),
    YHCD("youkaishomecoming", "[2.2.3,)"),
    BNCD_LEGACY("brewinandchewin_legacy", "[,3.0.0)"),
    BNCD("brewinandchewin", "[3.0.0,)"),
    FRD("farmersrespite"),
    L2_HARVESTER("l2harvester"),
    COPPER_POT("copperpot"),
    DUNGEONS_DELIGHT("dungeonsdelight"),
    DAPI("doapi"),
    DHB("herbalbrews"),
    DV("vinery", "[1.4.29,]"),
    DBN("bloomingnature"),
    DBR("brewery"),
    DBP("beachparty"),
    DCL("candlelight", "[2.0.0,]"),
    DBK("bakery", "[2.0.0,]"),
    DFC("farm_and_charm", "[1.0.0,]"),
    DM("meadow"),
    SF("simplefarming"),
    FS("fruitstack"),
    MS("supplementaries"),
    CP("crockpot"),
    DB("drinkbeer"),
    KK_LEGACY("kitchenkarrot", "[,0.5.4]"),
    KK_NEW("kitchenkarrot", "[0.6.2,]"),
    KK("kitchenkarrot"),
    TWT("thirst"),
    SS("sereneseasons"),
    ES("eclipticseasons"),
    MC("minecraft"){

        @Override
        public boolean isInstalled() {
            return true;
        }
    }
    ,
    KC("kaleidoscope_cookery"),
    TA("tea_aroma"),
    VTD("vintagedelight"),
    BAKERIES("bakeries"),
    IMD("immortalers_delight");

    private final String modId;
    private final String modName;
    private final String versionRange;
    private final boolean isLoaded;
    private final boolean versionLoaded;

    private Mods(String modId) {
        this.modId = modId;
        this.modName = ModUtil.getModName(modId);
        this.isLoaded = this.isInstalled();
        this.versionLoaded = this.isInstalled();
        this.versionRange = "";
    }

    private Mods(String modId, String versionRange) {
        this.modId = modId;
        this.modName = ModUtil.getModName(modId);
        this.versionRange = versionRange;
        this.isLoaded = this.isInstalled();
        this.versionLoaded = this.isInstalled(versionRange);
    }

    public static void init() {
    }

    public static Mods by(String mod) {
        return Mods.valueOf(mod);
    }

    public boolean isInstalled() {
        return ModUtil.isInstalled(this.modId);
    }

    protected boolean isInstalled(String versionRange) {
        return ModUtil.isInstalled(this.modId, versionRange);
    }

    public String getModActualVersion() {
        return ModUtil.getModVersion(this.modId);
    }

    @Override
    @NotNull
    public String getSerializedName() {
        return this.name();
    }

    @Override
    public String modId() {
        return this.modId;
    }

    @Override
    public String versionRange() {
        return this.versionRange;
    }

    @Override
    public boolean versionLoad() {
        return this.versionLoaded;
    }

    @Override
    public boolean load() {
        return this.isLoaded;
    }

    public String getModId() {
        return this.modId;
    }

    public String getModName() {
        return this.modName;
    }
}

