/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.manager;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ModTaskMixin;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ModTaskMixinMap;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.loading.LoadingModList;

public class TaskMixinManager {
    private static final String FILE_NAME = "mod_task_clazz.json";

    public static ModTaskMixinMap readModTaskMixinClazzFromFile() {
        try {
            HashMap<String, List<ModTaskMixin>> map = new HashMap<String, List<ModTaskMixin>>();
            Path resource = LoadingModList.get().getModFileById("maidsoulkitchen").getFile().findResource(new String[]{FILE_NAME});
            String json = Files.readString(resource);
            JsonObject jsonData = JsonParser.parseString((String)json).getAsJsonObject().getAsJsonObject("mixinInfo").getAsJsonObject("list");
            for (Map.Entry entry : jsonData.entrySet()) {
                String taskId = (String)entry.getKey();
                JsonArray vals = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement val : vals) {
                    JsonObject asJsonObject = val.getAsJsonObject();
                    String taskUid = asJsonObject.get("taskUid").getAsString();
                    String compatModKey = asJsonObject.get("compatMod").getAsString();
                    Mods compatMod = Mods.by(compatModKey);
                    JsonArray mixinList = asJsonObject.getAsJsonArray("mixinList");
                    ArrayList<String> mixins = new ArrayList<String>();
                    for (JsonElement mixin : mixinList) {
                        String mixinClazz = mixin.getAsString();
                        mixins.add(mixinClazz);
                    }
                    ModTaskMixin modTaskMixin = new ModTaskMixin(taskUid, compatMod, mixins);
                    map.computeIfAbsent(taskId, uid -> new ArrayList()).add(modTaskMixin);
                }
            }
            return new ModTaskMixinMap(map);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

