/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.barbequesdelight.grill;

import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.TickCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidItem;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.mao.barbequesdelight.content.block.GrillBlockEntity;
import com.mao.barbequesdelight.content.recipe.GrillingRecipe;
import com.mao.barbequesdelight.init.registrate.BBQDItems;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

@TaskClassAnalyzer(value=TaskInfo.BD_GRILL)
public class GrillCookRule
extends TickCookRule<GrillBlockEntity, GrillingRecipe<?>> {
    private static final GrillCookRule INSTANCE = new GrillCookRule();
    private ItemStack grillStack = ItemStack.f_41583_;

    public static GrillCookRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<GrillBlockEntity> cookBeBase, MaidCookManager<GrillingRecipe<?>> cm) {
        boolean innerCanCook = false;
        GrillBlockEntity blockEntity = cookBeBase.getBe();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        if (hasOutputAvailableSlot) {
            GrillBlockEntity.ItemEntry[] itemEntries;
            for (GrillBlockEntity.ItemEntry itemEntry : itemEntries = blockEntity.entries) {
                if (itemEntry.stack.m_150930_(BBQDItems.BURNT_FOOD.m_5456_())) {
                    return true;
                }
                if (itemEntry.stack.m_41619_()) continue;
                if (itemEntry.canFlip()) {
                    return true;
                }
                if (itemEntry.flipped && itemEntry.time >= itemEntry.duration) {
                    return true;
                }
                innerCanCook = true;
            }
        }
        return blockEntity.isHeated() && !innerCanCook && cm.hasMaidRecs(cookBeBase);
    }

    @Override
    public void cookMake(CookBeBase<GrillBlockEntity> cookBeBase, MaidCookManager<GrillingRecipe<?>> cm) {
        this.init(cookBeBase, cm);
        if (cm.hasMaidRecs(cookBeBase)) {
            ItemInventory itemInventory = cm.getItemInventory();
            MaidRec maidRec = cm.pollMaidRec(cookBeBase);
            MaidItem maidItem = maidRec.maidItems().get(0);
            this.grillStack = this.contItemStack(maidItem, itemInventory);
        }
    }

    @Override
    public void tickCookMake(CookBeBase<GrillBlockEntity> cookBeBase, MaidCookManager<GrillingRecipe<?>> cm) {
        GrillBlockEntity.ItemEntry[] itemEntries;
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        boolean nothing = true;
        for (GrillBlockEntity.ItemEntry itemEntry : itemEntries = ((GrillBlockEntity)this.be).entries) {
            ItemStack leftStack;
            ItemStack stack = itemEntry.stack;
            if (stack.m_150930_(BBQDItems.BURNT_FOOD.m_5456_())) {
                leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)stack.m_41777_(), (boolean)false);
                stack.m_41774_(stack.m_41613_() - leftStack.m_41613_());
                ((GrillBlockEntity)this.be).inventoryChanged();
                nothing = false;
                continue;
            }
            if (!stack.m_41619_()) {
                if (itemEntry.canFlip()) {
                    itemEntry.flip((GrillBlockEntity)this.be);
                    this.maid.m_6674_(InteractionHand.MAIN_HAND);
                }
                if (itemEntry.flipped && itemEntry.time >= itemEntry.duration) {
                    leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)stack.m_41777_(), (boolean)false);
                    stack.m_41774_(stack.m_41613_() - leftStack.m_41613_());
                    ((GrillBlockEntity)this.be).inventoryChanged();
                }
                nothing = false;
                continue;
            }
            if (this.grillStack.m_41619_() || this.grillStack.m_41619_() || !itemEntry.addItem((GrillBlockEntity)this.be, this.grillStack.m_255036_(1))) continue;
            this.maid.m_6674_(InteractionHand.MAIN_HAND);
            ((GrillBlockEntity)this.be).inventoryChanged();
            this.grillStack.m_41774_(1);
            nothing = false;
        }
        if (nothing) {
            this.stop();
            return;
        }
    }

    @Override
    public boolean tickCan(CookBeBase<GrillBlockEntity> cookBeBase, MaidCookManager<GrillingRecipe<?>> cm) {
        return super.tickCan(cookBeBase, cm);
    }

    @Override
    public void tickStop(CookBeBase<GrillBlockEntity> cookBeBase, MaidCookManager<GrillingRecipe<?>> cm) {
        super.tickStop(cookBeBase, cm);
        this.grillStack = ItemStack.f_41583_;
    }

    @Override
    protected TickCookRule<GrillBlockEntity, GrillingRecipe<?>> create() {
        return new GrillCookRule();
    }
}

