/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitPoi;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.maidsoulkitchen.task.cook.common.task.TaskCook;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PlaceFoodForPicnicTask
extends MaidCheckRateTask {
    @Nullable
    private EntitySit sitTmp;

    public PlaceFoodForPicnicTask() {
        super((Map)ImmutableMap.of());
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (!super.checkExtraStartConditions(worldIn, maid)) {
            return false;
        }
        if (!(maid.getTask() instanceof TaskCook)) {
            return false;
        }
        ItemStack hubItem = ItemCulinaryHub.getItem(maid);
        if (hubItem.m_41619_()) {
            return false;
        }
        List<BlockPos> validOutputPoses = ItemCulinaryHub.getValidOutputPoses(hubItem, maid);
        if (validOutputPoses.isEmpty()) {
            return false;
        }
        return this.findPicnicMat(worldIn, maid).isEmpty();
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
    }

    private List<Integer> collectPicnicMatAviFoodSlots(IItemHandlerModifiable picnicMatHandler) {
        ArrayList<Integer> aviSlots = new ArrayList<Integer>();
        for (int i = 0; i < picnicMatHandler.getSlots(); ++i) {
            ItemStack itemStack = picnicMatHandler.getStackInSlot(i);
            if (!itemStack.m_41619_()) continue;
            aviSlots.add(i);
        }
        return aviSlots;
    }

    private boolean placeFood(IItemHandlerModifiable outputHandler, IItemHandlerModifiable picnicMatHandler) {
        boolean place = false;
        for (int i = 0; i < outputHandler.getSlots(); ++i) {
            ItemStack itemStack = outputHandler.getStackInSlot(i);
            if (itemStack.m_41619_() || !itemStack.m_41614_()) continue;
            int slot = this.findAviFoodSlot(picnicMatHandler);
            if (slot != -1) {
                place = true;
                ItemStack copy = itemStack.m_41777_();
                ItemStack left = picnicMatHandler.insertItem(slot, copy, false);
                itemStack.m_41774_(copy.m_41613_() - left.m_41613_());
                continue;
            }
            return place;
        }
        return place;
    }

    private int findAviFoodSlot(IItemHandlerModifiable handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemStack = handler.getStackInSlot(i);
            if (!itemStack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    private boolean picnicMatHasFood(TileEntityPicnicMat picnicMat) {
        ItemStackHandler handler = picnicMat.getHandler();
        return this.picnicMatHasFood(handler);
    }

    private boolean picnicMatHasFood(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private List<BlockPos> findPicnicMat(ServerLevel world, EntityMaid maid) {
        BlockPos blockPos = maid.getBrainSearchPos();
        PoiManager poiManager = world.m_8904_();
        int range = (int)maid.m_21535_();
        return poiManager.m_27181_(type -> ((PoiType)type.get()).equals(InitPoi.HOME_MEAL_BLOCK.get()), blockPos, range, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).filter(pos -> this.hasMaid(world, (BlockPos)pos) && !this.hasFood(maid, (BlockPos)pos)).toList();
    }

    private boolean hasMaid(ServerLevel worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)te;
            for (UUID uuid : picnicMat.getSitIds()) {
                if (uuid.equals(Util.f_137441_) || worldIn.m_8791_(uuid) == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasFood(EntityMaid maid, BlockPos pos) {
        BlockEntity blockEntity = maid.f_19853_.m_7702_(pos);
        if (blockEntity instanceof TileEntityPicnicMat) {
            TileEntityPicnicMat picnicMat = (TileEntityPicnicMat)blockEntity;
            ItemStackHandler handler = picnicMat.getHandler();
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).m_41619_()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasRequiredMemories(EntityMaid pOwner) {
        return super.m_22543_((LivingEntity)pOwner);
    }
}

