/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown;

import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown.IItemDown;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.itemdown.RecDataUse;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.ItemAmount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HubItemDown
extends IItemDown {
    private int availableSlot;
    private int slotLimitCount;

    public HubItemDown() {
        this.availableSlot = BagType.INPUT.endIndex - 5;
        this.slotLimitCount = 64;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean read(RecDataUse recDataUse) {
        if (this.useSlot >= this.availableSlot) {
            return false;
        }
        Map<ItemDefinition, ItemAmount> itemUse = recDataUse.getItemUse();
        int recAmount = recDataUse.getRecipeRepeat();
        HashMap<ItemDefinition, Integer> useItemDef = new HashMap<ItemDefinition, Integer>();
        ArrayList<ItemDefinition> newPuts = new ArrayList<ItemDefinition>();
        boolean canPut = true;
        for (Map.Entry<ItemDefinition, ItemAmount> entry : itemUse.entrySet()) {
            ItemDefinition itemDefinition2 = entry.getKey();
            ItemAmount itemAmount = entry.getValue();
            boolean tool = itemAmount.isTool();
            if (tool) {
                Integer amount = (Integer)this.useItemDef.get(itemDefinition2);
                if (amount != null) continue;
                if (++this.useSlot > this.availableSlot) break;
                this.useItemDef.put(itemDefinition2, 1);
                newPuts.add(itemDefinition2);
                continue;
            }
            boolean isStackable = itemDefinition2.isStackable();
            int needCount = recAmount * itemAmount.needCount() * itemAmount.getRecAmount();
            if (!isStackable) {
                this.useSlot += needCount;
                if (this.useSlot > this.availableSlot) {
                    canPut = false;
                    break;
                }
                useItemDef.merge(itemDefinition2, needCount, Integer::sum);
                continue;
            }
            int maxStackSize = itemDefinition2.getMaxStackSize();
            int thisCount = 0;
            boolean thisHas = false;
            if (this.useItemDef.get(itemDefinition2) != null) {
                thisCount = (Integer)this.useItemDef.get(itemDefinition2);
                thisHas = true;
            }
            int inLineCount = 0;
            boolean inLineHas = false;
            if (useItemDef.get(itemDefinition2) != null) {
                inLineCount = (Integer)useItemDef.get(itemDefinition2);
                inLineHas = true;
            }
            if (thisHas) {
                if (inLineHas) {
                    leftUseSlot = (inLineCount + thisCount + needCount) % maxStackSize == 0 ? 1 : 0;
                    useSlot0 = (inLineCount + needCount) / maxStackSize + leftUseSlot;
                    this.useSlot += useSlot0;
                } else {
                    useSlot0 = needCount / maxStackSize + (needCount % maxStackSize > 0 ? 1 : 0);
                    this.useSlot += useSlot0;
                }
            } else if (inLineHas) {
                leftUseSlot = (inLineCount + needCount) % maxStackSize == 0 ? 1 : 0;
                useSlot0 = needCount / maxStackSize + leftUseSlot;
                this.useSlot += useSlot0;
            } else {
                useSlot0 = needCount / maxStackSize + (needCount % maxStackSize > 0 ? 1 : 0);
                this.useSlot += useSlot0;
            }
            if (this.useSlot > this.availableSlot) {
                canPut = false;
                break;
            }
            useItemDef.merge(itemDefinition2, needCount, Integer::sum);
        }
        if (!canPut) {
            for (ItemDefinition newPut : newPuts) {
                this.useItemDef.remove(newPut);
            }
            return false;
        }
        useItemDef.forEach((itemDefinition, count) -> this.useItemDef.merge(itemDefinition, count, Integer::sum));
        this.recLimitIndex += recAmount;
        return true;
    }
}

