/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.manager;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class GatherResult {
    public static GatherResult FAIL = new GatherResult(EmptyHandler.INSTANCE, Result.NOT_ENOUGH, 0, 0);
    private final IItemHandler itemHandler;
    private final Result result;
    private final int amount;
    private final int slot;

    public GatherResult(IItemHandler itemHandler, Result result, int amount, int slot) {
        this.itemHandler = itemHandler;
        this.result = result;
        this.amount = amount;
        this.slot = slot;
    }

    public GatherResult(IItemHandler itemHandler, int slot) {
        this(itemHandler, Result.DEFAULT, 0, slot);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public Result getResult() {
        return this.result;
    }

    public ItemStack queryItemStack() {
        return this.queryItemStack(this.amount);
    }

    public ItemStack queryItemStack(int amount) {
        return this.itemHandler.extractItem(this.slot, amount, false);
    }

    public ItemStack backItemStack(ItemStack backItem) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)backItem, (boolean)false);
    }

    public boolean isFail() {
        return this.result == Result.NOT_ENOUGH;
    }

    public static enum Result {
        DEFAULT,
        ENOUGH,
        NOT_ENOUGH;

    }
}

