/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.manager;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.IndexRange;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.wallev.maidsoulkitchen.util.BubbleUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class MaidConditionCookManager<R extends Recipe<? extends Container>, C>
extends MaidCookManager<R> {
    protected final int extraTryTimeMax = 20;
    protected Map<C, LinkedList<Integer>> tempIngredients = new HashMap<C, LinkedList<Integer>>();
    protected int extraTryTime = 0;
    protected Set<C> conditions;

    public MaidConditionCookManager(RecSerializerManager<R> recSerializerManager, EntityMaid maid, ICookTask<?, R> task, CookBeBase<?> cookBeBase) {
        super(recSerializerManager, maid, task, cookBeBase);
    }

    @Override
    public void initConditions() {
        this.conditions = this.collectValidConditions();
    }

    @Override
    public void clear() {
        super.clear();
        this.tempIngredients.clear();
        this.maidRecs.clear();
        this.conditions = null;
    }

    protected Set<C> collectValidConditions() {
        return this.collectConditions();
    }

    @Override
    protected void recAdd(MKRecipe<R> r, IndexRange indexRange) {
        C c = this.getRecipeCondition(r.rec());
        LinkedList list = this.tempIngredients.computeIfAbsent(c, k -> new LinkedList());
        for (int i = indexRange.start(); i < indexRange.end(); ++i) {
            list.add(i);
        }
    }

    @Override
    public boolean hasMaidRecs(CookBeBase<?> cookBeBase) {
        C beCondition = this.getBeCondition(cookBeBase);
        for (Map.Entry<C, LinkedList<Integer>> entry : this.tempIngredients.entrySet()) {
            if (!this.isValid(beCondition, entry.getKey())) continue;
            LinkedList<Integer> value = entry.getValue();
            return !value.isEmpty();
        }
        if (this.extraTryTime++ > 20) {
            this.extraTryTime = 0;
            this.tempIngredients.clear();
            this.maidRecs.clear();
        }
        return false;
    }

    @Override
    public MaidRec pollMaidRec(CookBeBase<?> cookBeBase) {
        C beCondition = this.getBeCondition(cookBeBase);
        for (Map.Entry<C, LinkedList<Integer>> entry : this.tempIngredients.entrySet()) {
            C key = entry.getKey();
            if (!this.isValid(beCondition, key)) continue;
            LinkedList<Integer> value = entry.getValue();
            Integer poll = value.poll();
            if (value.isEmpty()) {
                this.tempIngredients.remove(key);
            }
            assert (poll != null);
            MaidRec maidRec = (MaidRec)this.maidRecs.get(poll);
            assert (maidRec != null);
            BubbleUtil.makeResultsBubble(this.maid, maidRec);
            return maidRec;
        }
        return MaidRec.EMPTY;
    }

    @Override
    protected boolean recIsValid(MKRecipe<R> r) {
        return this.conditions.contains(this.getRecipeCondition(r.rec()));
    }

    protected abstract C getRecipeCondition(R var1);

    protected abstract C getBeCondition(CookBeBase<?> var1);

    protected abstract boolean isValid(C var1, C var2);

    protected final Set<C> collectConditions() {
        Level worldIn = this.maid.f_19853_;
        HashSet<C> conditions = new HashSet<C>();
        BlockPos centrePos = ICookTask.getSearchPos(this.maid);
        int searchRange = (int)this.maid.m_21535_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int y = 0;
        while (y <= 2) {
            for (int i = 0; i < searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.m_122154_((Vec3i)centrePos, x, y + 1, z);
                        if (this.maid.m_21444_((BlockPos)mutableBlockPos) && this.shouldMoveTo(worldIn, this.maid, (BlockPos)mutableBlockPos, this.cookBeBase)) {
                            conditions.add(this.getBeCondition(this.cookBeBase));
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        this.cookBeBase.clear();
        return conditions;
    }

    protected boolean shouldMoveTo(Level worldIn, EntityMaid maid, BlockPos blockPos, CookBeBase<?> cookBeBase) {
        BlockEntity blockEntity = worldIn.m_7702_(blockPos);
        if (blockEntity == null) {
            return false;
        }
        if (cookBeBase.isCookBe(blockEntity)) {
            cookBeBase.setBlockEntity(blockEntity);
            return true;
        }
        return false;
    }
}

