/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.util.MaidUtil;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NormalCookRule<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final NormalCookRule INSTANCE = new NormalCookRule();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> NormalCookRule<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        boolean hasResult = cookBeBase.hasResult();
        if (canTakeResult && hasResult && hasOutputAvailableSlot) {
            return true;
        }
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            return true;
        }
        boolean matchCookState = cookBeBase.cookStateMatch();
        return matchCookState && !hasInputs && cm.hasMaidRecs(cookBeBase);
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        boolean matchCookState;
        boolean pickAction = false;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        ItemStack result = cookBeBase.getResult();
        if (canTakeResult && !result.m_41619_() && hasOutputAvailableSlot) {
            boolean taken = cookBeBase.takeItem(result, (IItemHandler)outputInv);
            cookBeBase.awardExp();
            cookBeBase.markChanged();
            if (taken) {
                pickAction = true;
            }
        }
        boolean recMatch = cookBeBase.recMatch();
        boolean hasInputs = cookBeBase.hasInputs();
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
            pickAction = true;
        }
        if ((matchCookState = cookBeBase.cookStateMatch()) && !hasInputs && cm.hasMaidRecs(cookBeBase)) {
            ItemInventory itemInventory = cm.getItemInventory();
            cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
            cookBeBase.markChanged();
            cm.getItemInventory().markDirty();
            pickAction = true;
        }
        if (pickAction) {
            MaidUtil.pickupAction(cookBeBase);
        }
    }
}

