/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook;

import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid.IMaidCookInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.GatherResult;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.util.ItemStackUtil;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WaterCookRule<B extends BlockEntity, R extends Recipe<? extends Container>>
extends AbstractCookRule<B, R> {
    private static final WaterCookRule INSTANCE = new WaterCookRule();

    public static <B extends BlockEntity, R extends Recipe<? extends Container>> WaterCookRule<B, R> getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean canMoveTo(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        boolean hasResult = cookBeBase.hasResult();
        if (canTakeResult && hasResult && hasOutputAvailableSlot) {
            return true;
        }
        boolean cookStateMatch = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasEnoughFluid = cookBeBase.hasFluid();
        boolean hasInputs = cookBeBase.hasInputs();
        boolean findFuel = false;
        if (!recMatch && !hasInputs && cm.hasMaidRecs(cookBeBase) && cookStateMatch) {
            if (!hasEnoughFluid) {
                List<ItemStack> activeItemStacks = cookBeBase.getActiveItems();
                findFuel = cm.hasItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
                if (findFuel) {
                    return true;
                }
            } else {
                return true;
            }
            return true;
        }
        if (recMatch && !cookStateMatch && !hasEnoughFluid) {
            if (!findFuel) {
                List<ItemStack> activeItemStacks = cookBeBase.getActiveItems();
                findFuel = cm.hasItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
            }
            if (findFuel) {
                return true;
            }
        }
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            return true;
        }
        return hasEnoughFluid && cookStateMatch && !recMatch && hasInputAvailableSlot;
    }

    @Override
    public void cookMake(CookBeBase<B> cookBeBase, MaidCookManager<R> cm) {
        List<ItemStack> activeItemStacks;
        IItemHandlerModifiable inputInv = cm.getInputInv();
        IItemHandlerModifiable outputInv = cm.getOutputInv();
        IMaidCookInventory cookInv = cm.getCookInv();
        boolean hasInputAvailableSlot = cookInv.hasInputAvailableSlot();
        boolean hasOutputAvailableSlot = cookInv.hasOutputAvailableSlot();
        boolean canTakeResult = cookBeBase.canTakeResult();
        ItemStack result = cookBeBase.getResult();
        if (canTakeResult && !result.m_41619_() && hasOutputAvailableSlot) {
            cookBeBase.takeItem(result, (IItemHandler)outputInv);
            cookBeBase.awardExp();
            cookBeBase.markChanged();
        }
        boolean cookStateMatch = cookBeBase.cookStateMatch();
        boolean recMatch = cookBeBase.recMatch();
        boolean hasEnoughFluid = cookBeBase.hasFluid();
        boolean hasInputs = cookBeBase.hasInputs();
        GatherResult findFluidResult = GatherResult.FAIL;
        if (!recMatch && !hasInputs && cm.hasMaidRecs(cookBeBase)) {
            if (!cookStateMatch) {
                activeItemStacks = cookBeBase.getActiveItems();
                findFluidResult = cm.getItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
                if (!findFluidResult.isFail()) {
                    ItemInventory itemInventory = cm.getItemInventory();
                    cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
                    cookBeBase.markChanged();
                    recMatch = true;
                }
            } else {
                ItemInventory itemInventory = cm.getItemInventory();
                cookBeBase.insertInputs(cm.pollMaidRec(cookBeBase), itemInventory);
                cookBeBase.markChanged();
                recMatch = true;
            }
        }
        if (recMatch && !cookStateMatch && !hasEnoughFluid) {
            if (!findFluidResult.isFail()) {
                activeItemStacks = cookBeBase.getActiveItems();
                findFluidResult = cm.getItem(itemStack -> ItemStackUtil.isItem(activeItemStacks, itemStack));
            }
            if (!findFluidResult.isFail()) {
                ItemStack fluid = findFluidResult.queryItemStack(64);
                cookBeBase.useItem(fluid, () -> cookBeBase.hasFluid(), inputInv);
                findFluidResult.backItemStack(fluid);
                cookBeBase.markChanged();
            }
        }
        if (hasInputs && hasInputAvailableSlot && !recMatch) {
            cookBeBase.takeInputs((IItemHandler)inputInv);
            cookBeBase.markChanged();
        }
    }
}

