/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec;

import com.github.wallev.maidsoulkitchen.task.cook.common.inv.ingredient.RecIngredient;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.ItemAmount;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public abstract class ToolRecSerializerManager<R extends Recipe<? extends Container>>
extends RecSerializerManager<R> {
    protected ToolRecSerializerManager(RecipeType<R> recipeType) {
        super(recipeType);
    }

    @Override
    protected MKRecipe<R> createMKRecipe(R r) {
        List<RecIngredient> ingredients = this.recipeInfoProvider.getIngredients(this, r);
        ItemStack output = this.recipeInfoProvider.getOutput(this, r);
        ItemStack container = this.recipeInfoProvider.getContainer(this, r);
        boolean single = this.recipeInfoProvider.isSingle(this, r);
        RecIngredient tool = ((ToolRecipeInfoProvider)this.recipeInfoProvider).getTool(this, r);
        return new MKRecipe<R>(r, single, tool, ingredients, output, container);
    }

    @Override
    protected abstract ToolRecipeInfoProvider<R> createRecipeInfoProvider();

    @Override
    protected List<MaidRec> recProcess(MKRecipe<R> r, Map<ItemDefinition, Long> available, List<ItemDefinition> invIngredient, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes) {
        ItemStack tool = this.processTool(r, available, invIngredient, single, itemTimes);
        if (tool.m_41619_()) {
            return Collections.emptyList();
        }
        boolean processRecIngres = this.processRecIngres(r, available, invIngredient, single, itemTimes);
        if (!processRecIngres) {
            return Collections.emptyList();
        }
        return this.createCookRec(r, tool, available, single, invIngredient, itemTimes);
    }

    protected ItemStack processTool(MKRecipe<R> r, Map<ItemDefinition, Long> available, List<ItemDefinition> invIngredient, boolean[] single, Map<ItemDefinition, ItemAmount> itemTimes) {
        RecIngredient tool = r.tool();
        if (tool.isEmpty()) {
            return ItemStack.f_41583_;
        }
        for (ItemDefinition item : available.keySet()) {
            if (tool.test(item.stack()) <= 0) continue;
            return item.item().m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public static abstract class ToolRecipeInfoProvider<R extends Recipe<? extends Container>>
    extends RecSerializerManager.RecipeInfoProvider<R> {
        public abstract RecIngredient getTool(RecSerializerManager<R> var1, R var2);
    }
}

