/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.task;

import com.github.wallev.maidsoulkitchen.api.task.IMaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.task.CookTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.task.TaskCookIdle;
import com.github.wallev.maidsoulkitchen.util.ModUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class CookTaskManager {
    private static final List<LegacyCookTaskInfo> LEGACY_TASK = new ArrayList<LegacyCookTaskInfo>();
    private static CookTaskManager INSTANCE;
    private final ICookTask<?, ?> IDLE_TASK;
    private Map<ResourceLocation, ICookTask<?, ?>> TASK_MAP = new HashMap();
    private List<ICookTask<?, ?>> TASK_INDEX = new ArrayList();

    private CookTaskManager() {
        this.IDLE_TASK = new TaskCookIdle();
        for (CookTask cookTask : CookTask.values()) {
            if (!cookTask.canLoad.get().booleanValue()) continue;
            ICookTask<?, ?> task = cookTask.bindTask.get();
            task.setBindModName(ModUtil.getModName(cookTask.modId));
            this.add(task);
        }
        for (LegacyCookTaskInfo legacy : LEGACY_TASK) {
            if (!legacy.canLoad()) continue;
            ICookTask<?, ?> task = legacy.bindTask.get();
            task.setBindModName(ModUtil.getModName(legacy.bindMod.get().modId()));
            this.add(task);
        }
        this.makeImmutable();
    }

    public static void init() {
        CookTask.init();
        INSTANCE = new CookTaskManager();
    }

    public static Optional<ICookTask<?, ?>> findTask(ResourceLocation uid) {
        return Optional.ofNullable(CookTaskManager.INSTANCE.TASK_MAP.get(uid));
    }

    public static ICookTask<?, ?> getIdleTask() {
        return CookTaskManager.INSTANCE.IDLE_TASK;
    }

    public static Map<ResourceLocation, ICookTask<?, ?>> getTaskMap() {
        return CookTaskManager.INSTANCE.TASK_MAP;
    }

    public static List<ICookTask<?, ?>> getTaskIndex() {
        return CookTaskManager.INSTANCE.TASK_INDEX;
    }

    public void add(ICookTask<?, ?> task) {
        this.TASK_MAP.put(task.getUid(), task);
        this.TASK_INDEX.removeIf(ins -> ins.getUid().equals((Object)task.getUid()));
        this.TASK_INDEX.add(task);
    }

    private void makeImmutable() {
        this.TASK_MAP = ImmutableMap.copyOf(this.TASK_MAP);
        this.TASK_INDEX = ImmutableList.copyOf(this.TASK_INDEX);
    }

    public static void addLegacyTask(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<ICookTask<?, ?>> task, String ... mixinClz) {
        CookTaskManager.addLegacyTask(uid, bindMod, bindConfig, task, Lists.newArrayList((Object[])mixinClz));
    }

    public static void addLegacyTask(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<ICookTask<?, ?>> task, List<String> mixinClz) {
        LEGACY_TASK.add(new LegacyCookTaskInfo(uid, bindMod, bindConfig, task, mixinClz));
    }

    private record LegacyCookTaskInfo(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<ICookTask<?, ?>> bindTask, List<String> mixinClz) {
        public LegacyCookTaskInfo(Supplier<ResourceLocation> uid, Supplier<Mods> bindMod, Supplier<Boolean> bindConfig, Supplier<ICookTask<?, ?>> bindTask, String ... mixinClz) {
            this(uid, bindMod, bindConfig, bindTask, Lists.newArrayList((Object[])mixinClz));
        }

        public boolean canLoad() {
            return this.bindModLoad() && this.bindConfigLoad() && IMaidsoulKitchenTask.TaskMixinMap.isApplyMixin(this.getUid());
        }

        private ResourceLocation getUid() {
            return this.uid.get();
        }

        private boolean bindConfigLoad() {
            return this.bindConfig.get();
        }

        private boolean bindModLoad() {
            return this.bindMod.get().versionLoad();
        }
    }
}

