/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.farm;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmTask;
import com.github.wallev.maidsoulkitchen.compat.patchouli.entry.TaskBookEntryType;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.berryfruit.v1.BerryFruitData;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.DataRegister;
import com.github.wallev.maidsoulkitchen.task.MaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.task.farm.ai.MaidCompatFarmPlantTask;
import com.github.wallev.maidsoulkitchen.task.farm.ai.MaidCompatFruitMoveTask;
import com.github.wallev.maidsoulkitchen.task.farm.handler.fruit.FruitHandler;
import com.github.wallev.maidsoulkitchen.util.fakeplayer.WrappedMaidFakePlayer;
import com.github.wallev.maidsoulkitchen.vhelper.IModInfo;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;

public class TaskFruitFarm
extends ICompatFarmTask<FruitHandler> {
    @Override
    public List<Pair<Integer, VBehaviorControl>> vCreateBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Lists.newArrayList();
        }
        MaidCompatFruitMoveTask<FruitHandler> maidFarmMoveTask = new MaidCompatFruitMoveTask<FruitHandler>(maid, this, 0.6f);
        MaidCompatFarmPlantTask<FruitHandler> maidFarmPlantTask = new MaidCompatFarmPlantTask<FruitHandler>(maid, this, maidFarmMoveTask.getCompatFarmHandler());
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidFarmMoveTask), Pair.of((Object)6, maidFarmPlantTask)});
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, FruitHandler handler) {
        return handler != null && !BLACK_LIST.contains(cropState.m_60734_()) && handler.canHarvest(maid, cropPos, cropState);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, FruitHandler handler) {
        InteractionResult result = WrappedMaidFakePlayer.get(maid).useOnByHand(cropPos);
        if (result == InteractionResult.PASS) {
            BLACK_LIST.add(cropState.m_60734_());
            IModInfo.LOGGER.warn(BLACK_LIST.toString());
        }
    }

    @Override
    public double getCloseEnoughDist() {
        return 6.0;
    }

    @Override
    public BerryFruitData getDefaultData() {
        return BerryFruitData.createDefaultFruit();
    }

    public ResourceLocation getUid() {
        return MaidsoulKitchenTask.FRUIT_FARM.uid;
    }

    public ItemStack getIcon() {
        return Items.f_42410_.m_7968_();
    }

    @Override
    public TaskBookEntryType getBookEntryType() {
        return TaskBookEntryType.FRUIT_FARM;
    }

    @Override
    public TaskDataKey<BerryFruitData> getCookDataKey() {
        return DataRegister.FRUIT_FARM;
    }
}

