/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import com.github.wallev.maidsoulkitchen.util.TextContactUtil;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class BubbleUtil {
    public static void makeResultsBubbleWithEmpty(EntityMaid maid) {
        MutableComponent append = VComponent.translatable("chat_bubble.maidsoulkitchen.cook.no_ingredient_cook");
        TextChatBubbleData textChatBubbleData = TextChatBubbleData.type2((Component)append);
        maid.getChatBubbleManager().addChatBubble((IChatBubbleData)textChatBubbleData);
    }

    public static void makeResultsBubble(EntityMaid maid, Collection<MaidRec> recs) {
        HashMap<ItemStack, Integer> resultsMap = new HashMap<ItemStack, Integer>();
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (MaidRec maidRec : recs) {
            ItemStack result = maidRec.result();
            resultsMap.put(result, resultsMap.getOrDefault(result, 0) + maidRec.amount());
        }
        for (Map.Entry entry : resultsMap.entrySet()) {
            ItemStack key = (ItemStack)entry.getKey();
            int value = (Integer)entry.getValue();
            ItemStack copy = key.m_255036_(key.m_41613_() * value);
            results.add(copy);
        }
        BubbleUtil.makeResultsBubble(maid, results);
    }

    public static void makeResultsBubble(EntityMaid maid, List<ItemStack> results) {
        MutableComponent contact = TextContactUtil.contact(results, result -> VComponent.literal(result.m_41786_().getString() + " " + result.m_41613_()).m_7220_((Component)VComponent.translatable("chat_bubble.maidsoulkitchen.cook.food_amount")));
        MutableComponent append = VComponent.translatable("chat_bubble.maidsoulkitchen.cook.can_cook_these_food").m_7220_((Component)contact);
        TextChatBubbleData textChatBubbleData = TextChatBubbleData.type2((Component)append);
        maid.getChatBubbleManager().addChatBubble((IChatBubbleData)textChatBubbleData);
    }

    public static void makeResultsBubble(EntityMaid maid, ItemStack result, int existTick) {
        MutableComponent bubbleText = BubbleUtil.getBubbleText(maid, result);
        TextChatBubbleData textChatBubbleData = TextChatBubbleData.type2((Component)bubbleText);
        maid.getChatBubbleManager().addChatBubble((IChatBubbleData)textChatBubbleData);
    }

    public static void makeResultsBubble(EntityMaid maid, MaidRec maidRec) {
        BubbleUtil.makeResultsBubble(maid, maidRec.result(), maidRec.time());
    }

    public static MutableComponent getBubbleText(EntityMaid maid, ItemStack food) {
        LivingEntity owner = maid.m_269323_();
        String ownerName = owner == null ? VComponent.translatable("chat_bubble.maidsoulkitchen.cook.master").getString() : owner.m_5446_().getString();
        String name = food.m_41786_().getString();
        int count = food.m_41613_();
        int type = maid.m_217043_().m_188503_(4);
        return switch (type) {
            case 0 -> VComponent.translatable("chat_bubble.maidsoulkitchen.cook.make_food.0", ownerName, count, name);
            case 1 -> VComponent.translatable("chat_bubble.maidsoulkitchen.cook.make_food.1", count, name);
            case 2 -> VComponent.translatable("chat_bubble.maidsoulkitchen.cook.make_food.2", count, name);
            case 3 -> VComponent.translatable("chat_bubble.maidsoulkitchen.cook.make_food.3", name, count);
            default -> VComponent.translatable("chat_bubble.maidsoulkitchen.cook.make_food.4", count, name);
        };
    }
}

