/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class InvUtil {
    public static ItemStack getStack(IItemHandler inv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static int findStackSlot(IItemHandler inv, Predicate<ItemStack> predicate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!predicate.test(stack)) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getStack(IItemHandler inv, ItemStack itemStack) {
        return InvUtil.getStack(inv, itemStack.m_41720_());
    }

    public static ItemStack getStack(IItemHandler inv, Item item) {
        return InvUtil.getStack(inv, (ItemStack stack) -> stack.m_150930_(item));
    }

    public static boolean hasStack(IItemHandler inv, Predicate<ItemStack> predicate) {
        return !InvUtil.getStack(inv, predicate).m_41619_();
    }

    public static boolean hasStack(IItemHandler inv, ItemStack itemStack) {
        return !InvUtil.getStack(inv, itemStack.m_41720_()).m_41619_();
    }

    public static boolean hasStack(IItemHandler inv, Item item) {
        return !InvUtil.getStack(inv, item).m_41619_();
    }

    public static void insertAndPop(EntityMaid maid, List<ItemStack> stacks) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (ItemStack stack : stacks) {
            ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
            if (left.m_41619_()) continue;
            maid.f_19853_.m_7967_((Entity)new ItemEntity(maid.f_19853_, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), left));
        }
    }

    public static void insertAndPop(EntityMaid maid, ItemStack ... stacks) {
        InvUtil.insertAndPop(maid, List.of(stacks));
    }

    public static void insertAndPop(EntityMaid maid, ItemStack stack) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
        if (!left.m_41619_()) {
            maid.f_19853_.m_7967_((Entity)new ItemEntity(maid.f_19853_, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), left));
        }
    }

    public static void extractItem(ItemStack original, IItemHandler toInv, IItemHandler fromInv, int fromSlot) {
        ItemStack copy = original.m_41777_();
        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)toInv, (ItemStack)copy, (boolean)false);
        fromInv.extractItem(fromSlot, copy.m_41613_() - leftStack.m_41613_(), false);
    }

    public static void extractItem(ItemStack original, int count, IItemHandler toInv, IItemHandler fromInv, int fromSlot) {
        ItemStack copy = original.m_255036_(count);
        ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)toInv, (ItemStack)copy, (boolean)false);
        fromInv.extractItem(fromSlot, copy.m_41613_() - leftStack.m_41613_(), false);
    }
}

