/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.api.task.farm;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.wallev.maidsoulkitchen.api.IMaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.api.task.IDataTask;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatHandlerInfo;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.FarmData;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.MaidCompatFarmMoveTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.MaidCompatFarmPlantTask;
import com.github.wallev.maidsoulkitchen.task.farm.handler.IFarmHandlerManager;
import com.github.wallev.verhelper.server.ai.VBehaviorControl;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.state.BlockState;

public interface ICompatFarmTask<T extends ICompatFarmHandler & ICompatHandlerInfo, D extends FarmData>
extends IMaidsoulKitchenTask,
IDataTask<D> {
    public IFarmHandlerManager<T>[] getManagerHandlerValues();

    default public T getCompatHandler(EntityMaid maid) {
        List<String> farmTaskRulesList = ((FarmData)this.getTaskData(maid)).rules();
        ICompatFarmHandler.Builder<T> iCompatFarmHandlerBuilder = new ICompatFarmHandler.Builder<T>();
        for (IFarmHandlerManager<T> handler : this.getManagerHandlerValues()) {
            T farmHandler = handler.getFarmHandler();
            ResourceLocation uid = ((ICompatHandlerInfo)farmHandler).getUid();
            if (!farmTaskRulesList.contains(uid.toString())) continue;
            iCompatFarmHandlerBuilder.addHandler(farmHandler);
        }
        return iCompatFarmHandlerBuilder.build();
    }

    public boolean canHarvest(EntityMaid var1, BlockPos var2, BlockState var3, T var4);

    public void harvest(EntityMaid var1, BlockPos var2, BlockState var3, T var4);

    @Override
    default public List<Pair<Integer, VBehaviorControl>> vCreateBrainTasks(EntityMaid maid) {
        MaidCompatFarmMoveTask maidFarmMoveTask = new MaidCompatFarmMoveTask(maid, this, 0.6f);
        MaidCompatFarmPlantTask maidFarmPlantTask = new MaidCompatFarmPlantTask(maid, this, maidFarmMoveTask.getCompatFarmHandler());
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidFarmMoveTask), Pair.of((Object)6, maidFarmPlantTask)});
    }

    default public double getCloseEnoughDist() {
        return 1.0;
    }

    default public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_FARM.get()), (float)0.5f);
    }

    @Override
    public D getDefaultData();
}

