/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.tooltip;

import com.github.wallev.maidsoulkitchen.client.tooltip.ClientAmountTooltip;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.maidsoulkitchen.inventory.tooltip.CrockPotTooltip;
import com.github.wallev.maidsoulkitchen.task.cook.crokckpot.TaskCpCrockPot;
import com.github.wallev.verhelper.client.chat.VComponent;
import com.github.wallev.verhelper.client.resources.VResourceLocation;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMax;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMin;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.util.MathUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CrockPotAmountTooltip
implements ClientAmountTooltip {
    private static final ResourceLocation TEXTURE = VResourceLocation.create("maidsoulkitchen", "textures/gui/cook_guide.png");
    private final int rowSpacing = 2;
    private final int colSpacing = 2;
    private final MutableComponent titleTip = VComponent.translatable("tooltips.maidsoulkitchen.amount.title");
    private final CrockPotTooltip crockPotTooltip;
    private final String recipeId;
    private final TaskCpCrockPot.RecInfo1 recInfo1;
    private final Map<IRequirement, List<Item>> requirementListMap;
    private final Boolean isBlacklist;
    private final CookData cookData;
    private final boolean isOverSize;
    private final int rows;
    private final int cols;

    public CrockPotAmountTooltip(CrockPotTooltip crockPotTooltip) {
        this.crockPotTooltip = crockPotTooltip;
        this.recipeId = crockPotTooltip.recipeId();
        this.recInfo1 = crockPotTooltip.recInfo1();
        this.requirementListMap = crockPotTooltip.requirementListMap();
        this.isBlacklist = crockPotTooltip.isRandom();
        this.isOverSize = crockPotTooltip.isOverSize();
        this.cookData = crockPotTooltip.cookData();
        int count = this.recInfo1.getNoRequires().size() + this.recInfo1.getAnyRequires().size() + this.recInfo1.getMustRequires().size() + this.recInfo1.getMinRequires().size() + this.recInfo1.getMinERequires().size() + this.recInfo1.getMaxRequires().size() + this.recInfo1.getMaxERequires().size() + this.recInfo1.getMustLessRequires().size();
        this.cols = count <= 2 ? 2 : (count == 3 ? 3 : (count == 4 ? 2 : 3));
        this.rows = count % this.cols == 0 ? count / this.cols : count / this.cols + 1;
    }

    public int m_142103_() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9 + 2 + 10 + 10 + this.rows * 24;
    }

    public int m_142069_(Font font) {
        int tipMax = font.m_92852_((FormattedText)this.titleTip);
        MutableComponent type = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.warn.now_type").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.type.%s", this.isBlacklist != false ? "blacklist" : "whitelist")));
        tipMax = Math.max(tipMax, font.m_92852_((FormattedText)type));
        MutableComponent canCook = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.can_cook").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.can_cook.%s", this.canCook() ? "true" : "false")));
        tipMax = Math.max(tipMax, font.m_92852_((FormattedText)canCook));
        return Math.max(tipMax, this.cols * 66);
    }

    public void m_183452_(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        MutableComponent mutableComponent;
        int xOffset;
        ItemStack[] items;
        int yOffset;
        ItemStack itemStack;
        FoodCategory category;
        MutableComponent cookType = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.warn.now_type").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.type.%s", this.isBlacklist != false ? "blacklist" : "whitelist")));
        guiGraphics.m_280430_(font, (Component)cookType, pX, pY, ChatFormatting.YELLOW.m_126665_().intValue());
        MutableComponent canCook = VComponent.translatable("gui.maidsoulkitchen.btn.cook_guide.can_cook").m_7220_((Component)VComponent.translatable(String.format("gui.maidsoulkitchen.btn.cook_guide.can_cook.%s", this.canCook() ? "true" : "false"))).m_130940_(this.canCook() ? ChatFormatting.GREEN : ChatFormatting.RED);
        guiGraphics.m_280430_(font, (Component)canCook, pX, pY += 10, ChatFormatting.YELLOW.m_126665_().intValue());
        guiGraphics.m_280430_(font, (Component)this.titleTip, pX, pY += 10, ChatFormatting.GRAY.m_126665_().intValue());
        pY += 10;
        int i = 0;
        for (RequirementCategoryMax requirementCategoryMax : this.recInfo1.getNoRequires()) {
            category = requirementCategoryMax.getCategory();
            itemStack = FoodCategory.getItemStack((FoodCategory)category);
            int xOffset2 = pX + i % this.cols * 66;
            yOffset = pY + i / this.cols * 24;
            guiGraphics.m_280218_(TEXTURE, xOffset2, yOffset, 192, 234, 64, 22);
            guiGraphics.m_280480_(itemStack, xOffset2 + 3, yOffset + 3);
            MutableComponent mutableComponent2 = MathUtils.fuzzyIsZero((float)requirementCategoryMax.getMax()) ? VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.no") : VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.le", Float.valueOf(requirementCategoryMax.getMax()));
            guiGraphics.m_280614_(font, (Component)mutableComponent2, xOffset2 + 3 + 16 + 2, yOffset + 8, ChatFormatting.BLACK.m_126665_().intValue(), false);
            ++i;
        }
        for (RequirementCategoryMinExclusive requirementCategoryMinExclusive : this.recInfo1.getAnyRequires()) {
            category = requirementCategoryMinExclusive.getCategory();
            itemStack = FoodCategory.getItemStack((FoodCategory)category);
            int xOffset2 = pX + i % this.cols * 66;
            yOffset = pY + i / this.cols * 24;
            guiGraphics.m_280218_(TEXTURE, xOffset2, yOffset, 192, 234, 64, 22);
            guiGraphics.m_280480_(itemStack, xOffset2 + 3, yOffset + 3);
            MutableComponent mutableComponent2 = MathUtils.fuzzyIsZero((float)requirementCategoryMinExclusive.getMin()) ? VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.any") : VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.gt", Float.valueOf(requirementCategoryMinExclusive.getMin()));
            guiGraphics.m_280614_(font, (Component)mutableComponent2, xOffset2 + 3 + 16 + 2, yOffset + 8, ChatFormatting.BLACK.m_126665_().intValue(), false);
            ++i;
        }
        for (RequirementMustContainIngredient requirementMustContainIngredient : this.recInfo1.getMustRequires()) {
            category = requirementMustContainIngredient.getIngredient();
            items = category.m_43908_();
            ItemStack itemStack2 = items[0];
            xOffset = pX + i % this.cols * 66;
            int yOffset2 = pY + i / this.cols * 24;
            guiGraphics.m_280218_(TEXTURE, xOffset, yOffset2, 192, 234, 64, 22);
            guiGraphics.m_280480_(itemStack2, xOffset + 3, yOffset2 + 3);
            if (items.length > 1) {
                guiGraphics.m_280218_(TEXTURE, xOffset + 3, yOffset2 + 3 + 13, 0, 253, 3, 3);
            }
            mutableComponent = VComponent.translatable(requirementMustContainIngredient.getQuantity() >= 4 ? "integration.crockpot.jei.crock_pot_cooking.requirement.eq" : "integration.crockpot.jei.crock_pot_cooking.requirement.ge", requirementMustContainIngredient.getQuantity());
            guiGraphics.m_280614_(font, (Component)mutableComponent, xOffset + 3 + 16 + 2, yOffset2 + 8, ChatFormatting.BLACK.m_126665_().intValue(), false);
            ++i;
        }
        for (RequirementCategoryMin requirementCategoryMin : this.recInfo1.getMinRequires()) {
            category = requirementCategoryMin.getCategory();
            itemStack = FoodCategory.getItemStack((FoodCategory)category);
            int xOffset3 = pX + i % this.cols * 66;
            yOffset = pY + i / this.cols * 24;
            guiGraphics.m_280218_(TEXTURE, xOffset3, yOffset, 192, 234, 64, 22);
            guiGraphics.m_280480_(itemStack, xOffset3 + 3, yOffset + 3);
            MutableComponent mutableComponent3 = VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.ge", Float.valueOf(requirementCategoryMin.getMin()));
            guiGraphics.m_280614_(font, (Component)mutableComponent3, xOffset3 + 3 + 16 + 2, yOffset + 8, ChatFormatting.BLACK.m_126665_().intValue(), false);
            ++i;
        }
        for (RequirementCategoryMinExclusive requirementCategoryMinExclusive : this.recInfo1.getMinERequires()) {
            category = requirementCategoryMinExclusive.getCategory();
            itemStack = FoodCategory.getItemStack((FoodCategory)category);
            int xOffset4 = pX + i % this.cols * 66;
            yOffset = pY + i / this.cols * 24;
            guiGraphics.m_280218_(TEXTURE, xOffset4, yOffset, 192, 234, 64, 22);
            guiGraphics.m_280480_(itemStack, xOffset4 + 3, yOffset + 3);
            MutableComponent mutableComponent4 = MathUtils.fuzzyIsZero((float)requirementCategoryMinExclusive.getMin()) ? VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.any") : VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.gt", Float.valueOf(requirementCategoryMinExclusive.getMin()));
            guiGraphics.m_280614_(font, (Component)mutableComponent4, xOffset4 + 3 + 16 + 2, yOffset + 8, ChatFormatting.BLACK.m_126665_().intValue(), false);
            ++i;
        }
        for (RequirementCategoryMax requirementCategoryMax : this.recInfo1.getMaxRequires()) {
            category = requirementCategoryMax.getCategory();
            itemStack = FoodCategory.getItemStack((FoodCategory)category);
            int xOffset5 = pX + i % this.cols * 66;
            yOffset = pY + i / this.cols * 24;
            guiGraphics.m_280218_(TEXTURE, xOffset5, yOffset, 192, 234, 64, 22);
            guiGraphics.m_280480_(itemStack, xOffset5 + 3, yOffset + 3);
            MutableComponent mutableComponent5 = MathUtils.fuzzyIsZero((float)requirementCategoryMax.getMax()) ? VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.no") : VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.le", Float.valueOf(requirementCategoryMax.getMax()));
            guiGraphics.m_280614_(font, (Component)mutableComponent5, xOffset5 + 3 + 16 + 2, yOffset + 8, ChatFormatting.BLACK.m_126665_().intValue(), false);
            ++i;
        }
        for (RequirementCategoryMaxExclusive requirementCategoryMaxExclusive : this.recInfo1.getMaxERequires()) {
            category = requirementCategoryMaxExclusive.getCategory();
            itemStack = FoodCategory.getItemStack((FoodCategory)category);
            int xOffset6 = pX + i % this.cols * 66;
            yOffset = pY + i / this.cols * 24;
            guiGraphics.m_280218_(TEXTURE, xOffset6, yOffset, 192, 234, 64, 22);
            guiGraphics.m_280480_(itemStack, xOffset6 + 3, yOffset + 3);
            MutableComponent mutableComponent6 = VComponent.translatable("integration.crockpot.jei.crock_pot_cooking.requirement.lt", Float.valueOf(requirementCategoryMaxExclusive.getMax()));
            guiGraphics.m_280614_(font, (Component)mutableComponent6, xOffset6 + 3 + 16 + 2, yOffset + 8, ChatFormatting.BLACK.m_126665_().intValue(), false);
            ++i;
        }
        for (RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan : this.recInfo1.getMustLessRequires()) {
            category = requirementMustContainIngredientLessThan.getIngredient();
            items = category.m_43908_();
            ItemStack itemStack3 = items[0];
            xOffset = pX + i % this.cols * 66;
            int yOffset3 = pY + i / this.cols * 24;
            guiGraphics.m_280218_(TEXTURE, xOffset, yOffset3, 192, 234, 64, 22);
            guiGraphics.m_280480_(itemStack3, xOffset + 3, yOffset3 + 3);
            if (items.length > 1) {
                guiGraphics.m_280218_(TEXTURE, xOffset + 3, yOffset3 + 3 + 13, 0, 253, 3, 3);
            }
            guiGraphics.m_280480_(itemStack3, xOffset, yOffset3);
            mutableComponent = VComponent.translatable(requirementMustContainIngredientLessThan.getQuantity() >= 4 ? "integration.crockpot.jei.crock_pot_cooking.requirement.eq" : "integration.crockpot.jei.crock_pot_cooking.requirement.le", requirementMustContainIngredientLessThan.getQuantity());
            guiGraphics.m_280614_(font, (Component)mutableComponent, xOffset + 3 + 16 + 2, yOffset3 + 8, ChatFormatting.BLACK.m_126665_().intValue(), false);
            ++i;
        }
    }

    private boolean canCook() {
        if (this.isBlacklist.booleanValue()) {
            return !this.cookData.blacklistRecs().contains(this.recipeId);
        }
        return this.cookData.whitelistRecs().contains(this.recipeId);
    }
}

