/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.api.task.farm;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.wallev.maidsoulkitchen.api.task.IDataTask;
import com.github.wallev.maidsoulkitchen.api.task.IMaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatHandlerInfo;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.berryfruit.v1.BerryFruitData;
import com.github.wallev.maidsoulkitchen.inventory.container.maid.FruitFarmConfigContainer;
import com.github.wallev.maidsoulkitchen.task.farm.ai.MaidCompatFarmMoveTask;
import com.github.wallev.maidsoulkitchen.task.farm.ai.MaidCompatFarmPlantTask;
import com.github.wallev.maidsoulkitchen.task.farm.handler.IFarmHandlerManager;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ICompatFarmTask<T extends ICompatFarmHandler & ICompatHandlerInfo>
implements IMaidsoulKitchenTask,
IDataTask<BerryFruitData> {
    public static Set<Block> BLACK_LIST = new HashSet<Block>();
    private final List<IFarmHandlerManager<T>> handlerManagers = this.createHandlerManagers();

    private List<IFarmHandlerManager<T>> createHandlerManagers() {
        return IFarmHandlerManager.getHandlerManagers(this.getUid());
    }

    public List<IFarmHandlerManager<T>> getHandlerManagers() {
        return this.handlerManagers;
    }

    public T getCompatHandler(EntityMaid maid) {
        BerryFruitData taskData = (BerryFruitData)this.getTaskData(maid);
        ICompatFarmHandler.Builder<T> iCompatFarmHandlerBuilder = new ICompatFarmHandler.Builder<T>();
        for (IFarmHandlerManager<T> handler : this.handlerManagers) {
            T farmHandler = handler.getFarmHandler();
            ResourceLocation uid = ((ICompatHandlerInfo)farmHandler).getUid();
            if (!taskData.containRule(uid.toString())) continue;
            iCompatFarmHandlerBuilder.addHandler(farmHandler);
        }
        return iCompatFarmHandlerBuilder.build();
    }

    public abstract boolean canHarvest(EntityMaid var1, BlockPos var2, BlockState var3, T var4);

    public abstract void harvest(EntityMaid var1, BlockPos var2, BlockState var3, T var4);

    @Override
    public List<Pair<Integer, VBehaviorControl>> vCreateBrainTasks(EntityMaid maid) {
        MaidCompatFarmMoveTask maidFarmMoveTask = new MaidCompatFarmMoveTask(maid, this, 0.6f);
        MaidCompatFarmPlantTask maidFarmPlantTask = new MaidCompatFarmPlantTask(maid, this, maidFarmMoveTask.getCompatFarmHandler());
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidFarmMoveTask), Pair.of((Object)6, maidFarmPlantTask)});
    }

    public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Fruit Farm Config Container");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                return new FruitFarmConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    public double getCloseEnoughDist() {
        return 1.0;
    }

    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_FARM.get()), (float)0.5f);
    }

    @Override
    public abstract BerryFruitData getDefaultData();
}

