/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.client.gui.entity.maid.farm;

import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmHandler;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatFarmTask;
import com.github.wallev.maidsoulkitchen.api.task.farm.ICompatHandlerInfo;
import com.github.wallev.maidsoulkitchen.client.gui.entity.maid.MaidTaskConfigGui;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.CFRuleButton;
import com.github.wallev.maidsoulkitchen.client.gui.widget.info.ResultInfo;
import com.github.wallev.maidsoulkitchen.client.gui.widget.info.Zone;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.berryfruit.v1.BerryFruitData;
import com.github.wallev.maidsoulkitchen.inventory.container.maid.FruitFarmConfigContainer;
import com.github.wallev.maidsoulkitchen.network.NetworkHandler;
import com.github.wallev.maidsoulkitchen.task.farm.handler.IFarmHandlerManager;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
@OnlyIn(value=Dist.CLIENT)
public class FruitFarmConfigGui
extends MaidTaskConfigGui<FruitFarmConfigContainer> {
    private static final ResourceLocation TEXTURE = VResourceLocation.create("maidsoulkitchen", "textures/gui/farm_guide.png");
    protected final Zone scrollDisplay = new Zone(161, 47, 9, 110);
    protected final Zone ruleDisplay = new Zone(6, 47, 152, 110);
    protected final ResultInfo ref = new ResultInfo(3, 1, 152, 24, 0, 5);
    private final int limitSize = this.ref.row() * this.ref.col();
    private ICompatFarmTask<?> compatFarmTask;
    private List<? extends IFarmHandlerManager<?>> handlers;
    private BerryFruitData berryFruitData;

    public FruitFarmConfigGui(FruitFarmConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)screenContainer.getMaid().getTask().getName().m_7220_((Component)VComponent.translatable("gui.maidsoulkitchen.farm_config_screen.title")));
    }

    protected void initAdditionData() {
        super.initAdditionData();
        this.compatFarmTask = (ICompatFarmTask)this.task;
        this.handlers = this.compatFarmTask.getHandlerManagers();
        this.berryFruitData = (BerryFruitData)this.compatFarmTask.getTaskData(this.maid);
    }

    @Override
    protected void initAdditionWidgets() {
        super.initAdditionWidgets();
        this.addRetrievalButton();
        this.addRuleButton();
        this.addScrollButton();
    }

    protected void initBaseData() {
        super.initBaseData();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.berryFruitData == null) {
            return;
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void addRetrievalButton() {
        MutableComponent literal = VComponent.translatable("gui.maidsoulkitchen.fruit_farm_configer_screen.farm.fruit.search_y_offset", "--");
        int x = this.f_96547_.m_92852_((FormattedText)literal);
        int startX = this.visualZone.startX() + 6 + 26 + x;
        int startY = this.visualZone.startY() + 22 + 2;
        ImageButton addButton = new ImageButton(startX, startY, 17, 18, 80, 238, 0, TEXTURE, b -> {
            if (this.berryFruitData.searchYOffset() >= 5) {
                return;
            }
            this.berryFruitData.increaseYOffset();
            NetworkHandler.C2S.syncBerryFruitData(this.maid.m_19879_(), this.compatFarmTask.getCookDataKey().getKey(), this.berryFruitData);
        });
        ImageButton downButton = new ImageButton(startX + 17, startY, 17, 18, 97, 238, 0, TEXTURE, b -> {
            if (this.berryFruitData.searchYOffset() <= -5) {
                return;
            }
            this.berryFruitData.decreaseYOffset();
            NetworkHandler.C2S.syncBerryFruitData(this.maid.m_19879_(), this.compatFarmTask.getCookDataKey().getKey(), this.berryFruitData);
        });
        this.m_142416_((GuiEventListener)addButton);
        this.m_142416_((GuiEventListener)downButton);
    }

    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderAddition(graphics, mouseX, mouseY, partialTicks);
        this.renderRetrieval(graphics);
        this.drawScrollInfoBar(graphics);
    }

    private void renderRetrieval(GuiGraphics graphics) {
        MutableComponent literal = VComponent.translatable("gui.maidsoulkitchen.fruit_farm_configer_screen.farm.fruit.search_y_offset", this.berryFruitData.searchYOffset());
        int width = this.f_96547_.m_92852_((FormattedText)literal);
        int x = this.visualZone.startX() + 6;
        int y = this.visualZone.startY() + 22;
        graphics.m_280218_(TEXTURE, x, y, 0, 236, 22, 20);
        if (this.berryFruitData.searchYOffset() >= 0) {
            width += this.f_96547_.m_92852_((FormattedText)Component.m_237113_((String)"-"));
            for (int i = 0; i < width; ++i) {
                graphics.m_280218_(TEXTURE, x + 22 + i, y, 22, 236, 1, 20);
            }
            graphics.m_280218_(TEXTURE, x + 22 + width, y, 76, 236, 8, 20);
        } else {
            for (int i = 0; i < width; ++i) {
                graphics.m_280218_(TEXTURE, x + 22 + i, y, 22, 236, 1, 20);
            }
            graphics.m_280218_(TEXTURE, x + 22 + width, y, 76, 236, 8, 20);
        }
        graphics.m_280480_(this.task.getIcon(), x + 2, y + 2);
        graphics.m_280614_(this.f_96547_, (Component)literal, x + 22, y + 7, Color.WHITE.getRGB(), false);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean isCookSettingMainZone;
        boolean bl = isCookSettingMainZone = mouseX >= (double)this.visualZone.startX() && mouseY >= (double)this.visualZone.startY() && mouseX < (double)(this.visualZone.startX() + this.visualZone.width()) && mouseY < (double)(this.visualZone.startY() + this.visualZone.height());
        if (delta != 0.0 && isCookSettingMainZone) {
            if (delta > 0.0 && this.solIndex > 0) {
                --this.solIndex;
                this.m_7856_();
                return true;
            }
            if (delta < 0.0 && this.solIndex < (this.handlers.size() - 1) / this.limitSize) {
                ++this.solIndex;
                this.m_7856_();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void addRuleButton() {
        int index;
        int startX = this.visualZone.startX() + this.ruleDisplay.startX();
        int startY = this.visualZone.startY() + this.ruleDisplay.startY();
        for (int i = index = this.solIndex * this.limitSize; i < Math.min(this.handlers.size(), index + this.limitSize); ++i) {
            Object handler = this.handlers.get(i).getFarmHandler();
            String handlerUid = ((ICompatHandlerInfo)handler).getUid().toString();
            boolean contains = this.berryFruitData.containRule(handlerUid);
            CFRuleButton cfRuleButton = new CFRuleButton((ICompatHandlerInfo)handler, (ICompatFarmHandler)handler, contains, startX, startY, this.getTaskTooltips((ICompatHandlerInfo)handler)){

                public void m_5716_(double pMouseX, double pMouseY) {
                    this.isSelected = !this.isSelected;
                    FruitFarmConfigGui.this.berryFruitData.setRule(this.handlerInfo.getUid().toString(), this.isSelected);
                    NetworkHandler.C2S.syncBerryFruitData(FruitFarmConfigGui.this.maid.m_19879_(), FruitFarmConfigGui.this.compatFarmTask.getCookDataKey().getKey(), FruitFarmConfigGui.this.berryFruitData);
                }
            };
            this.m_142416_((GuiEventListener)cfRuleButton);
            startY += this.ref.colHeight() + this.ref.colSpacing();
        }
    }

    private void addScrollButton() {
        int startX = this.visualZone.startX() + this.scrollDisplay.startX();
        int startY = this.visualZone.startY() + this.scrollDisplay.startY();
        ImageButton upButton = new ImageButton(startX, startY, 9, 7, 228, 10, 14, TEXTURE, b -> {
            if (this.solIndex > 0) {
                --this.solIndex;
                this.m_7856_();
            }
        });
        ImageButton downButton = new ImageButton(startX, startY + 8 + 1 + 66, 9, 7, 237, 10, 14, TEXTURE, b -> {
            if (this.solIndex < (this.handlers.size() - 1) / this.limitSize) {
                ++this.solIndex;
                this.m_7856_();
            }
        });
        this.m_142416_((GuiEventListener)upButton);
        this.m_142416_((GuiEventListener)downButton);
    }

    private void drawScrollInfoBar(GuiGraphics graphics) {
        int startX = this.visualZone.startX() + this.scrollDisplay.startX();
        int startY = this.visualZone.startY() + this.scrollDisplay.startY();
        graphics.m_280218_(TEXTURE, startX, startY + 8, 247, 8, 9, 2);
        graphics.m_280218_(TEXTURE, startX, startY + 8 + 2, 247, 10, 9, 62);
        graphics.m_280218_(TEXTURE, startX, startY + 8 + 2 + 62, 247, 100, 9, 2);
        this.drawScrollIndicator(graphics, startX + 1, startY + 8 + 1);
    }

    private void drawScrollIndicator(GuiGraphics graphics, int startX, int startY) {
        if ((this.handlers.size() - 1) / this.limitSize >= 1) {
            graphics.m_280218_(TEXTURE, startX, startY + (int)(55.0f * this.getCurrentScroll()), 228, 0, 7, 9);
        } else {
            graphics.m_280218_(TEXTURE, startX, startY, 235, 0, 7, 9);
        }
    }

    private float getCurrentScroll() {
        return Mth.m_14036_((float)((float)((double)this.solIndex * (1.0 / (double)((this.handlers.size() - 1) / this.limitSize)))), (float)0.0f, (float)1.0f);
    }

    private List<Component> getTaskTooltips(ICompatHandlerInfo iHandlerInfo) {
        List<Component> conditionDescription;
        List<Component> desc = iHandlerInfo.getDescription(this.maid);
        if (!desc.isEmpty()) {
            desc.add(0, (Component)VComponent.translatable("task.touhou_little_maid.desc.title").m_130940_(ChatFormatting.GOLD));
        }
        if (!(conditionDescription = iHandlerInfo.getConditionDescription(this.maid)).isEmpty()) {
            desc.add((Component)Component.m_237113_((String)" "));
            desc.add((Component)VComponent.translatable("task.touhou_little_maid.desc.condition").m_130940_(ChatFormatting.GOLD));
        }
        for (Component line : conditionDescription) {
            MutableComponent prefix = Component.m_237113_((String)"- ");
            desc.add((Component)prefix.m_7220_(line));
        }
        return desc;
    }
}

