/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.compat.msm.common.inv;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.github.wallev.maidsoulkitchen.compat.msm.common.inv.IInvHandlerFactory;
import com.github.wallev.maidsoulkitchen.compat.msm.common.inv.InvHandlerRegister;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskModClazzManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

@TaskClassAnalyzer(value=TaskInfo.MSM_CORE)
public class InvHandlersHelper {
    static final Map<BlockEntityType<?>, IInvHandlerFactory<?>> INV_HANDLERS = new HashMap();

    @Nullable
    public static IInvHandlerFactory<?> get(BlockEntityType<?> type) {
        return INV_HANDLERS.get(type);
    }

    public static void init() {
        INV_HANDLERS.clear();
        InvHandlersHelper.register(InvHandlerRegister.class, TaskModClazzManager.getCheckManager());
    }

    private static void register(Class<?> annotationClass, BaseClazzCheckManager<?, ?> checkManager) {
        Type annotationType = Type.getType(annotationClass);
        ModList.get().getAllScanData().stream().flatMap(scanData -> scanData.getAnnotations().stream()).filter(annotationData -> Objects.equals(annotationData.annotationType(), annotationType)).forEach(data -> {
            try {
                Object task = checkManager.taskInfoByKey(InvHandlersHelper.getEnumHolderValue(data, "value"));
                if (task != null && task.canLoad()) {
                    String clazzName = data.memberName();
                    Class<?> asmClazz = Class.forName(clazzName);
                    asmClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException | InvocationTargetException e) {
                MaidsoulKitchen.LOGGER.error("Failed to load class: {}", data, (Object)e);
            }
        });
    }

    private static String getEnumHolderValue(ModFileScanData.AnnotationData data, String name) {
        Object o = data.annotationData().get(name);
        return ((ModAnnotation.EnumHolder)o).getValue();
    }
}

