/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.event;

import com.github.wallev.maidsoulkitchen.config.subconfig.TaskConfig;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="maidsoulkitchen", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlackHubChestDefineEvent {
    public static final Set<Block> BLACK_HUB_CHEST_LIST = new HashSet<Block>();
    private static final String CONFIG_NAME = "maidsoulkitchen-common.toml";

    @SubscribeEvent
    public static void onEvent(ModConfigEvent.Loading event) {
        String fileName = event.getConfig().getFileName();
        if (CONFIG_NAME.equals(fileName)) {
            BlackHubChestDefineEvent.handleConfig();
        }
    }

    public static void handleConfig() {
        BLACK_HUB_CHEST_LIST.clear();
        BlackHubChestDefineEvent.handleMelonAndStemList((List)TaskConfig.BLACK_HUB_CHEST_LIST.get(), BLACK_HUB_CHEST_LIST);
    }

    private static void handleMelonAndStemList(List<String> config, Set<Block> output) {
        for (String blockId : config) {
            Block block;
            ResourceLocation location = VResourceLocation.tryParse(blockId);
            if (location == null || (block = (Block)ForgeRegistries.BLOCKS.getValue(location)) == null) continue;
            output.add(block);
        }
    }
}

