/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.network.packet.c2s;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.CookDataV1;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.KitchenData;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.DataRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record SyncKitchenDataC2SMessage(int maidId, KitchenData kitchenData) {
    public static void encode(SyncKitchenDataC2SMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.maidId());
        KitchenData kitchenData = message.kitchenData();
        buf.m_130085_(kitchenData.getCookName());
        buf.m_130130_(kitchenData.getCookDatas().size());
        kitchenData.getCookDatas().forEach((typeName, cookData) -> {
            buf.m_130085_(typeName);
            SyncKitchenDataC2SMessage.encodeCookData(cookData, buf);
        });
    }

    public static SyncKitchenDataC2SMessage decode(FriendlyByteBuf buf) {
        int maidId = buf.readInt();
        ResourceLocation kitchenName = buf.m_130281_();
        HashMap cookDataMap = Maps.newHashMap();
        int cookDataSize = buf.m_130242_();
        for (int i = 0; i < cookDataSize; ++i) {
            ResourceLocation typeName = buf.m_130281_();
            CookDataV1 cookData = SyncKitchenDataC2SMessage.decodeCookData(buf);
            cookDataMap.put(typeName, cookData);
        }
        return new SyncKitchenDataC2SMessage(maidId, new KitchenData(cookDataMap, kitchenName));
    }

    private static void encodeCookData(CookDataV1 cookData, FriendlyByteBuf buf) {
        buf.m_130070_(cookData.mode());
        buf.m_130130_(cookData.whitelistRecs().size());
        cookData.whitelistRecs().forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
        buf.m_130130_(cookData.blacklistRecs().size());
        cookData.blacklistRecs().forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130070_(arg_0));
    }

    private static CookDataV1 decodeCookData(FriendlyByteBuf buf) {
        String mode = buf.m_130277_();
        int whiteListSize = buf.m_130242_();
        ArrayList whiteList = Lists.newArrayList();
        for (int i = 0; i < whiteListSize; ++i) {
            String whiteRec = buf.m_130277_();
            whiteList.add(whiteRec);
        }
        int blackListSize = buf.m_130242_();
        ArrayList blackList = Lists.newArrayList();
        for (int i = 0; i < blackListSize; ++i) {
            String blackRec = buf.m_130277_();
            blackList.add(blackRec);
        }
        return new CookDataV1(mode, whiteList, blackList);
    }

    public static void handle(SyncKitchenDataC2SMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.maidId());
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    TaskDataKey kitchenDataTaskDataKey2 = TaskDataRegister.getValue((ResourceLocation)DataRegister.COOK.getKey());
                    maid.setAndSyncData(kitchenDataTaskDataKey2, (Object)message.kitchenData());
                }
            });
        }
        context.setPacketHandled(true);
    }
}

