/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task;

import com.github.wallev.maidsoulkitchen.api.task.IMaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.Mods;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskModClazzManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.task.TaskCook;
import com.github.wallev.maidsoulkitchen.task.farm.TaskBerryFarm;
import com.github.wallev.maidsoulkitchen.task.farm.TaskCompatMelonFarm;
import com.github.wallev.maidsoulkitchen.task.farm.TaskEsFarm;
import com.github.wallev.maidsoulkitchen.task.farm.TaskFruitFarm;
import com.github.wallev.maidsoulkitchen.task.farm.TaskSsFarm;
import com.github.wallev.maidsoulkitchen.task.farm.handler.IFarmHandlerManager;
import com.github.wallev.maidsoulkitchen.task.farm.handler.berry.BerryHandlerManager;
import com.github.wallev.maidsoulkitchen.task.farm.handler.fruit.FruitHandlerManager;
import com.github.wallev.maidsoulkitchen.task.other.TaskFeedAnimalT;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MaidsoulKitchenTask {
    COMPAT_MELON_FARM(TaskInfo.COMPAT_MELON_FARM, TaskCompatMelonFarm::new),
    BERRY_FARM(TaskInfo.BERRY_FARM, TaskBerryFarm::new){

        @Override
        protected void putTask(TaskInfo taskInfo, Supplier<IMaidsoulKitchenTask> bindTask) {
            IMaidsoulKitchenTask.putTask(this.uid, () -> {
                boolean taskCanLoad = taskInfo.canLoad();
                if (taskCanLoad) {
                    ArrayList<BerryHandlerManager> handlers = new ArrayList<BerryHandlerManager>();
                    for (BerryHandlerManager value : BerryHandlerManager.VALUES) {
                        if (!value.getBindMod().versionLoad() || !TaskModClazzManager.clazzLoad(value.getUid().toString())) continue;
                        handlers.add(value);
                    }
                    IFarmHandlerManager.registerHandler(this.uid, ImmutableList.copyOf(handlers));
                }
                return taskCanLoad;
            }, bindTask);
        }
    }
    ,
    FRUIT_FARM(TaskInfo.FRUIT_FARM, TaskFruitFarm::new){

        @Override
        protected void putTask(TaskInfo taskInfo, Supplier<IMaidsoulKitchenTask> bindTask) {
            IMaidsoulKitchenTask.putTask(this.uid, () -> {
                boolean taskCanLoad = taskInfo.canLoad();
                if (taskCanLoad) {
                    ArrayList<FruitHandlerManager> handlers = new ArrayList<FruitHandlerManager>();
                    for (FruitHandlerManager value : FruitHandlerManager.VALUES) {
                        if (!value.getBindMod().versionLoad() || !TaskModClazzManager.clazzLoad(value.getUid().toString())) continue;
                        handlers.add(value);
                    }
                    IFarmHandlerManager.registerHandler(this.uid, ImmutableList.copyOf(handlers));
                }
                return taskCanLoad;
            }, bindTask);
        }
    }
    ,
    FEED_ANIMAL_T(TaskInfo.FEED_ANIMAL_T, TaskFeedAnimalT::new),
    SERENESEASONS_FARM(TaskInfo.SERENESEASONS_FARM, TaskSsFarm::new),
    ECLIPTICSSEASONS_FARM(TaskInfo.ECLIPTICSSEASONS_FARM, TaskEsFarm::new),
    COOK(TaskInfo.COOK, TaskCook::new);

    public final ResourceLocation uid;
    public final String modId;

    private MaidsoulKitchenTask(String uid, Mods bindMod, ForgeConfigSpec.BooleanValue bindConfig, Supplier<IMaidsoulKitchenTask> bindTask) {
        this.uid = VResourceLocation.create("maidsoulkitchen", uid);
        this.modId = bindMod.modId();
        this.putTask(uid, bindMod, bindConfig, bindTask);
    }

    private MaidsoulKitchenTask(TaskInfo taskInfo, Supplier<IMaidsoulKitchenTask> bindTask) {
        this.uid = taskInfo.getUid();
        this.modId = taskInfo.getBindMod().modId();
        this.putTask(taskInfo, bindTask);
    }

    public static void init() {
    }

    protected void putTask(String uid, Mods bindMod, ForgeConfigSpec.BooleanValue bindConfig, Supplier<IMaidsoulKitchenTask> bindTask) {
        IMaidsoulKitchenTask.putTask(this.uid, () -> bindMod.versionLoad() && (Boolean)bindConfig.get() != false && TaskModClazzManager.clazzLoad(this.uid.toString()), bindTask);
    }

    protected void putTask(TaskInfo taskInfo, Supplier<IMaidsoulKitchenTask> bindTask) {
        IMaidsoulKitchenTask.putTask(this.uid, () -> taskInfo.canLoad(), bindTask);
    }
}

