/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.farmersdelight.cuttingboard;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemDefinition;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.TickCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.MaidRec;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

@TaskClassAnalyzer(value=TaskInfo.FD_CUTTING_BOARD)
public class CuttingBoardCookRule
extends TickCookRule<CuttingBoardBlockEntity, CuttingBoardRecipe> {
    private static final CuttingBoardCookRule INSTANCE = new CuttingBoardCookRule();
    private boolean maidHand = false;
    private Item processItem = null;

    @Override
    public boolean canMoveTo(CookBeBase<CuttingBoardBlockEntity> cookBeBase, MaidCookManager<CuttingBoardRecipe> cm) {
        CuttingBoardBlockEntity cuttingBoard = cookBeBase.getBe();
        if (!cuttingBoard.isEmpty() && this.hasBoardStackTool(cookBeBase.getMaid(), cuttingBoard)) {
            return true;
        }
        return cuttingBoard.getStoredItem().m_41619_() && cm.hasMaidRecs(cookBeBase);
    }

    @Override
    public void cookMake(CookBeBase<CuttingBoardBlockEntity> cookBeBase, MaidCookManager<CuttingBoardRecipe> cm) {
        this.init(cookBeBase, cm);
        ItemStack storedItem = ((CuttingBoardBlockEntity)this.be).getStoredItem();
        if (!storedItem.m_41619_()) {
            ItemStack tool = this.getBoardStackTool(this.maid, (CuttingBoardBlockEntity)this.be);
            if (tool.m_41619_()) {
                this.tickStop(cookBeBase, cm);
                return;
            }
            this.swapItem(InteractionHand.MAIN_HAND, tool, this.maid, (IItemHandler)this.maid.getAvailableInv(true));
            ((CuttingBoardBlockEntity)this.be).processStoredItemUsingTool(tool, null);
            if (!storedItem.m_41619_()) {
                this.processItem = storedItem.m_41720_();
                ((CuttingBoardBlockEntity)this.be).m_6596_();
                return;
            }
        }
        if (cm.hasMaidRecs(cookBeBase)) {
            MaidRec maidRec = cm.pollMaidRec(cookBeBase);
            ItemStack tool = maidRec.tool();
            ItemInventory itemInventory = cm.getItemInventory();
            ItemStack pollTool = itemInventory.getItemStacks(tool.m_41720_()).poll();
            if (pollTool == null) {
                return;
            }
            this.swapItem(InteractionHand.MAIN_HAND, pollTool, this.maid, (IItemHandler)this.maid.getAvailableInv(true));
            ItemDefinition processItem = maidRec.maidItems().get(0).item();
            ItemStack processItemPoll = itemInventory.getItemStacks(processItem).poll();
            if (processItemPoll == null) {
                return;
            }
            this.swapItem(InteractionHand.OFF_HAND, processItemPoll, this.maid, (IItemHandler)this.maid.getAvailableInv(true));
            this.processItem = processItem.item();
            cm.getItemInventory().markDirty();
        }
        ((CuttingBoardBlockEntity)this.be).m_6596_();
    }

    @Override
    public boolean tickCan(CookBeBase<CuttingBoardBlockEntity> cookBeBase, MaidCookManager<CuttingBoardRecipe> cm) {
        return this.be != null && !this.maid.m_21205_().m_41619_() && this.processItem != null && (this.maid.m_21206_().m_150930_(this.processItem) || this.isProcessItem());
    }

    @Override
    public void tickCookMake(CookBeBase<CuttingBoardBlockEntity> cookBeBase, MaidCookManager<CuttingBoardRecipe> cm) {
        if (this.tick++ % 5 != 0) {
            return;
        }
        if (this.maidHand) {
            ItemStack tool = this.maid.m_21205_();
            ((CuttingBoardBlockEntity)this.be).processStoredItemUsingTool(tool, null);
            this.maid.m_6674_(InteractionHand.MAIN_HAND);
        } else {
            ItemStack offhandItem = this.maid.m_21206_();
            if (offhandItem.m_150930_(this.processItem)) {
                ItemStack split = offhandItem.m_41620_(1);
                ((CuttingBoardBlockEntity)this.be).getInventory().insertItem(0, split, false);
                this.maid.m_6674_(InteractionHand.OFF_HAND);
            }
        }
        this.maidHand = !this.maidHand;
    }

    private boolean hasBoardStackTool(EntityMaid maid, CuttingBoardBlockEntity blockEntity) {
        return !this.getBoardStackTool(maid, blockEntity).m_41619_();
    }

    private ItemStack getBoardStackTool(EntityMaid maid, CuttingBoardBlockEntity blockEntity) {
        Level level = maid.f_19853_;
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        IItemHandler inventory = blockEntity.getInventory();
        RecipeWrapper recipeWrapper = new RecipeWrapper((IItemHandlerModifiable)inventory);
        Optional recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CUTTING.get(), (Container)recipeWrapper, level);
        if (recipe.isPresent()) {
            Ingredient tool = ((CuttingBoardRecipe)recipe.get()).getTool();
            return ItemsUtil.getStack((IItemHandler)maidInv, itemStack -> tool.test(itemStack));
        }
        return ItemStack.f_41583_;
    }

    private boolean isProcessItem() {
        return ((CuttingBoardBlockEntity)this.be).getStoredItem().m_150930_(this.processItem);
    }

    @Override
    public void tickStop(CookBeBase<CuttingBoardBlockEntity> cookBeBase, MaidCookManager<CuttingBoardRecipe> cm) {
        super.tickStop(cookBeBase, cm);
        this.processItem = null;
        this.maidHand = false;
    }

    @Override
    protected TickCookRule<CuttingBoardBlockEntity, CuttingBoardRecipe> create() {
        return new CuttingBoardCookRule();
    }

    public static CuttingBoardCookRule getInstance() {
        return INSTANCE;
    }
}

