/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.CookDataV1;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.KitchenData;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.DataRegister;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class OldDataHelper {
    private static final String TASK_DATA_TAG_NAME = "MaidTaskDataMaps";
    private static final String MAID_TASK_TAG_NAME = "MaidTask";
    private static final List<OldTaskInfo> WILL_TRANS_TASK_INFO;
    private static final List<String> WILL_TRANS_TASK_STR;
    private static final TaskDataKey<KitchenData> DATA_KEY;
    private static final String COOK_DATA_KEY_STRING;
    private static final Map<String, ResourceLocation> WILL_TRANS_TASK_STR_MAP;

    public static void transOldKitchenData(CompoundTag entityTag) {
        if (!entityTag.m_128441_(TASK_DATA_TAG_NAME)) {
            return;
        }
        CompoundTag taskDataTag = entityTag.m_128469_(TASK_DATA_TAG_NAME);
        if (taskDataTag.m_128456_() || taskDataTag.m_128441_(COOK_DATA_KEY_STRING)) {
            return;
        }
        Map<ResourceLocation, CookDataV1> taskInfoCookDataMap = OldDataHelper.collectOldKitchenData(taskDataTag);
        if (taskInfoCookDataMap.isEmpty()) {
            return;
        }
        CompoundTag taskDataTagCompound = taskDataTag.m_128469_(COOK_DATA_KEY_STRING);
        KitchenData kitchenData = taskDataTagCompound.m_128456_() ? new KitchenData() : (KitchenData)DATA_KEY.readSaveData(taskDataTagCompound);
        taskInfoCookDataMap.forEach((taskInfo, cookData) -> {
            kitchenData.setCookData((ResourceLocation)taskInfo, (CookDataV1)cookData);
            taskDataTag.m_128473_(taskInfo.toString());
        });
        entityTag.m_128359_(MAID_TASK_TAG_NAME, TaskInfo.COOK.getUid().toString());
        String maidTask = entityTag.m_128461_(MAID_TASK_TAG_NAME);
        if (WILL_TRANS_TASK_STR.contains(maidTask)) {
            kitchenData.setCookName(WILL_TRANS_TASK_STR_MAP.get(maidTask));
        }
        CompoundTag kitchenDataTag = DATA_KEY.writeSaveData((Object)kitchenData);
        taskDataTag.m_128365_(COOK_DATA_KEY_STRING, (Tag)kitchenDataTag);
    }

    private static Map<ResourceLocation, CookDataV1> collectOldKitchenData(CompoundTag taskDataTag) {
        HashMap taskInfoCookDataMap = Maps.newHashMap();
        for (OldTaskInfo taskInfo : WILL_TRANS_TASK_INFO) {
            CompoundTag compound = taskDataTag.m_128469_(taskInfo.str());
            if (compound.m_128456_()) continue;
            CookDataV1.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compound).result().ifPresent(cookData -> taskInfoCookDataMap.put(taskInfo.uid(), cookData));
        }
        return taskInfoCookDataMap;
    }

    static {
        DATA_KEY = DataRegister.COOK;
        COOK_DATA_KEY_STRING = DATA_KEY.getKey().toString();
        ImmutableList willTransTaskInfo = ImmutableList.of((Object)TaskInfo.FURNACE, (Object)TaskInfo.FD_COOK_POT, (Object)TaskInfo.FD_CUTTING_BOARD, (Object)TaskInfo.CD_CUISINE_SKILLET, (Object)TaskInfo.MD_COOK_POT, (Object)TaskInfo.BNC_KEY, (Object)TaskInfo.BD_BASIN, (Object)TaskInfo.BD_GRILL, (Object)TaskInfo.YHC_MOKA, (Object)TaskInfo.YHC_TEA_KETTLE, (Object)TaskInfo.YHC_DRYING_RACK, (Object)TaskInfo.YHC_FERMENTATION_TANK, (Object[])new TaskInfo[]{TaskInfo.CP_CROCK_POT, TaskInfo.DB_BEER, TaskInfo.KK_BREW_BARREL, TaskInfo.KK_AIR_COMPRESSOR});
        WILL_TRANS_TASK_INFO = willTransTaskInfo.stream().map(OldTaskInfo::new).toList();
        WILL_TRANS_TASK_STR = willTransTaskInfo.stream().map(TaskInfo::getUid).map(ResourceLocation::toString).toList();
        WILL_TRANS_TASK_STR_MAP = willTransTaskInfo.stream().collect(Collectors.toUnmodifiableMap(TaskInfo::getOldName, TaskInfo::getUid));
    }

    private record OldTaskInfo(ResourceLocation uid, String str) {
        public OldTaskInfo(TaskInfo taskInfo) {
            this(taskInfo.getUid(), taskInfo.getOldName());
        }
    }
}

