/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.modclazzchecker.core.lang;

import com.github.wallev.maidsoulkitchen.modclazzchecker.core.classana.ITaskInfo;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.lang.TaskErrorLang;
import com.github.wallev.maidsoulkitchen.modclazzchecker.core.manager.BaseClazzCheckManager;
import com.github.wallev.maidsoulkitchen.util.AnnotationHelper;
import java.lang.reflect.Field;
import org.objectweb.asm.Type;

public class TaskErrorLangRead {
    public static void init(BaseClazzCheckManager<?, ?> clazzCheckManager) {
        Type annotationType = clazzCheckManager.getErrorTaskLangAnnotationType();
        AnnotationHelper.read(annotationType, data -> {
            String className = data.clazz().getClassName();
            String fieldName = data.memberName();
            String enUs = (String)AnnotationHelper.getHolderValue(data, "en_us");
            String zhCn = (String)AnnotationHelper.getHolderValue(data, "zh_cn");
            String enUsDesc = (String)AnnotationHelper.getHolderValue(data, "en_us_desc");
            String zhCnDesc = (String)AnnotationHelper.getHolderValue(data, "zh_cn_desc");
            TaskErrorLang taskErrorLang = new TaskErrorLang(enUs == null ? "" : enUs, zhCn == null ? "" : zhCn, enUsDesc == null ? "" : enUsDesc, zhCnDesc == null ? "" : zhCnDesc);
            Field annotatedField = TaskErrorLangRead.getAnnotatedField(className, fieldName);
            try {
                Object fieldValue = annotatedField.get(null);
                if (fieldValue instanceof ITaskInfo) {
                    ITaskInfo taskInfo = (ITaskInfo)fieldValue;
                    String uidStr = taskInfo.getUidStr();
                    clazzCheckManager.addErrorTaskLang(uidStr, taskErrorLang);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("[TaskErrorLang]Exception: " + className + "#" + fieldName, e);
            }
        });
    }

    private static Field getAnnotatedField(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("[TaskErrorLang]ClassNotFoundException: " + className, e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("[TaskErrorLang]NoSuchFieldException: " + className + "#" + fieldName, e);
        }
        catch (Exception e) {
            throw new RuntimeException("[TaskErrorLang]Exception: " + className + "#" + fieldName, e);
        }
    }
}

