/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.network.packet.c2s;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v0.CookData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record ActionCookDataRecsPacket(int entityId, ResourceLocation dataKey, List<String> recs, boolean add) {
    public static void encode(ActionCookDataRecsPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.m_130085_(message.dataKey);
        List<String> recs = message.recs();
        int size = recs.size();
        buf.m_130130_(size);
        for (String rec : recs) {
            buf.m_130070_(rec);
        }
        buf.writeBoolean(message.add);
    }

    public static ActionCookDataRecsPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        ResourceLocation dataKey = buf.m_130281_();
        int size = buf.m_130242_();
        ArrayList<String> recs = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            recs.add(buf.m_130277_());
        }
        boolean add = buf.readBoolean();
        return new ActionCookDataRecsPacket(entityId, dataKey, recs, add);
    }

    public static void handle(ActionCookDataRecsPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    TaskDataKey value = TaskDataRegister.getValue((ResourceLocation)message.dataKey);
                    CookData cookData = (CookData)maid.getOrCreateData(value, (Object)new CookData());
                    boolean add = message.add();
                    List<String> recs = message.recs();
                    if (add) {
                        cookData.addRecs(recs);
                    } else {
                        cookData.removeRecs(recs);
                    }
                    maid.setAndSyncData(value, (Object)cookData);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

