/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.task.cook.common.inv.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.task.cook.common.inv.item.ItemInventory;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class IMaidCookInventory {
    protected final EntityMaid maid;
    protected final ItemInventory itemInventory = new ItemInventory();
    protected int inputAvailableSlots = 0;
    protected int outputAvailableSlots = 0;
    protected boolean hasInputAvailableSlot = false;
    protected boolean hasOutputAvailableSlot = false;

    protected IMaidCookInventory(EntityMaid maid) {
        this.maid = maid;
    }

    protected abstract void initInvData();

    public abstract void refreshInv();

    protected abstract void proseLastInvStack(int var1, ItemStack var2);

    protected abstract void clearCacheStackInfo();

    protected abstract void add(ItemStack var1);

    public abstract Map<Item, List<ItemStack>> getInventoryStack();

    public Map<Item, LinkedList<ItemStack>> getInventoryStackQueue() {
        LinkedHashMap<Item, LinkedList<ItemStack>> itemQueueLinkedHashMap = new LinkedHashMap<Item, LinkedList<ItemStack>>();
        this.getInventoryStack().forEach((item, itemStacks) -> itemQueueLinkedHashMap.computeIfAbsent((Item)item, k -> new LinkedList()).addAll(itemStacks));
        return itemQueueLinkedHashMap;
    }

    public abstract Map<Item, Integer> getInventoryItem();

    public abstract List<ItemStack> getLastInvStack();

    public abstract IItemHandlerModifiable getAvailableInv(BagType var1);

    public abstract IItemHandlerModifiable getInputInv();

    public abstract IItemHandlerModifiable getOutputInv();

    public void syncInv() {
    }

    public ItemInventory getItemInventory() {
        return this.itemInventory;
    }

    public void calcAvailableSlots() {
        int a = 0;
        IItemHandlerModifiable inputInv = this.getInputInv();
        this.hasInputAvailableSlot = false;
        for (int i = 0; i < inputInv.getSlots(); ++i) {
            if (!inputInv.getStackInSlot(i).m_41619_()) continue;
            this.hasInputAvailableSlot = true;
            ++a;
        }
        this.inputAvailableSlots = a;
        a = 0;
        IItemHandlerModifiable outputInv = this.getOutputInv();
        this.hasOutputAvailableSlot = false;
        for (int i = 0; i < outputInv.getSlots(); ++i) {
            if (!outputInv.getStackInSlot(i).m_41619_()) continue;
            this.hasOutputAvailableSlot = true;
            ++a;
        }
        this.outputAvailableSlots = a;
        a = 0;
    }

    public int getInputAvailableSlots() {
        return this.inputAvailableSlots;
    }

    public int getOutputAvailableSlots() {
        return this.outputAvailableSlots;
    }

    public boolean hasInputAvailableSlot() {
        return this.hasInputAvailableSlot;
    }

    public boolean hasOutputAvailableSlot() {
        return this.hasOutputAvailableSlot;
    }
}

