/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util.fakeplayer;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.wallev.maidsoulkitchen.api.task.IMaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.util.fakeplayer.WrappedMaidFakePlayer;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class WrappedMaidInventory
extends Inventory {
    private final EntityMaid maid;
    private Function<EntityMaid, IItemHandlerModifiable> invSupplier;

    public WrappedMaidInventory(EntityMaid maid, WrappedMaidFakePlayer fakePlayer) {
        super((Player)fakePlayer);
        this.maid = maid;
        this.resetInv();
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public IItemHandlerModifiable getInv() {
        return this.invSupplier.apply(this.maid);
    }

    protected IItemHandlerModifiable defaultTaskInv() {
        IMaidTask task = this.maid.getTask();
        if (task instanceof IMaidsoulKitchenTask) {
            IMaidsoulKitchenTask maidsoulKitchenTask = (IMaidsoulKitchenTask)task;
            return maidsoulKitchenTask.getInventory(this.maid);
        }
        return this.maid.getAvailableInv(true);
    }

    public void setInvSupplier(Function<EntityMaid, IItemHandlerModifiable> invSupplier) {
        this.invSupplier = invSupplier;
        this.rebuildItems();
        this.rebuildCompartments();
    }

    private void rebuildCompartments() {
        this.f_35979_ = ImmutableList.of((Object)this.f_35974_, (Object)this.f_35975_, (Object)this.f_35976_);
    }

    private void rebuildItems() {
        IItemHandlerModifiable inv = this.getInv();
        int slots = inv.getSlots();
        NonNullList list = NonNullList.m_182647_((int)slots);
        for (int i = 0; i < slots; ++i) {
            list.add((Object)inv.getStackInSlot(i));
        }
        this.f_35974_ = list;
    }

    public void resetInv() {
        this.setInvSupplier(maid0 -> this.defaultTaskInv());
    }

    public void stacks(Consumer<ItemStack> stack) {
        IItemHandlerModifiable inv = this.getInv();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack0 = inv.getStackInSlot(i);
            if (stack0.m_41619_()) continue;
            stack.accept(stack0);
        }
    }

    public ItemStack getItemStack(Predicate<ItemStack> predicate) {
        return ItemsUtil.getStack((IItemHandler)this.getInv(), predicate);
    }

    public ItemStack getItemStack(ItemStack itemStack) {
        return this.getItemStack((ItemStack stack) -> stack == itemStack);
    }

    public ItemStack getItemStack(Item item) {
        return this.getItemStack((ItemStack stack) -> stack.m_150930_(item));
    }

    public boolean hasItemStack(Predicate<ItemStack> predicate) {
        return ItemsUtil.findStackSlot((IItemHandler)this.getInv(), predicate) > -1;
    }

    public boolean hasItemStack(ItemStack itemStack) {
        return this.hasItemStack((ItemStack stack) -> stack == itemStack);
    }

    public boolean hasItemStack(Item item) {
        return this.hasItemStack((ItemStack stack) -> stack.m_150930_(item));
    }

    public ItemStack insert(ItemStack itemStack, boolean simulate) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.getInv(), (ItemStack)itemStack, (boolean)simulate);
    }

    public void insertWithDrop(ItemStack itemStack) {
        ItemStack leftStack = this.insert(itemStack, false);
        if (!leftStack.m_41619_()) {
            this.maid.f_19853_.m_7967_((Entity)new ItemEntity(this.maid.f_19853_, this.maid.m_20185_(), this.maid.m_20186_(), this.maid.m_20189_(), leftStack));
        }
    }

    public boolean extract(ItemStack stack) {
        ItemStack itemStack = this.getItemStack((ItemStack stack0) -> stack0 == stack);
        if (!itemStack.m_41619_()) {
            itemStack.m_41764_(0);
            return true;
        }
        return false;
    }

    public int m_18947_(Item item) {
        int count = 0;
        IItemHandlerModifiable inv = this.getInv();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!stack.m_150930_(item)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public boolean m_18949_(Set<Item> itemSet) {
        return this.hasItemStack((ItemStack stack) -> itemSet.contains(stack.m_41720_()));
    }

    public boolean m_216874_(Predicate<ItemStack> predicate) {
        return this.hasItemStack(predicate);
    }

    public ItemStack m_36056_() {
        return this.maid.m_21205_();
    }

    public void m_36012_(ItemStack stack) {
        this.insertWithDrop(stack);
    }

    public boolean m_36054_(ItemStack stack) {
        ItemStack itemStack = this.insert(stack, true);
        if (!itemStack.m_41619_()) {
            return false;
        }
        this.insert(stack, false);
        return true;
    }

    public void m_150079_(ItemStack stack) {
        this.m_150076_(stack, true);
    }

    public void m_150076_(ItemStack stack, boolean sendPacket) {
        this.insertWithDrop(stack);
    }

    public void m_36057_(ItemStack stack) {
        this.extract(stack);
    }

    public float m_36020_(BlockState state) {
        return this.m_36056_().m_41691_(state);
    }

    public void m_36068_() {
    }

    public ListTag m_36026_(ListTag listTag) {
        return listTag;
    }

    public void m_36035_(ListTag listTag) {
    }

    public boolean m_7983_() {
        return super.m_7983_();
    }

    public Component m_7755_() {
        return super.m_7755_();
    }

    public ItemStack m_36052_(int pSlot) {
        return super.m_36052_(pSlot);
    }

    public void m_150072_(DamageSource pSource, float pDamage, int[] pArmorPieces) {
        super.m_150072_(pSource, pDamage, pArmorPieces);
    }

    public void m_36071_() {
        super.m_36071_();
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public int m_36072_() {
        return super.m_36072_();
    }

    public boolean m_6542_(Player pPlayer) {
        return super.m_6542_(pPlayer);
    }

    public boolean m_36063_(ItemStack stack) {
        return super.m_36063_(stack);
    }

    public boolean m_204075_(TagKey<Item> pTag) {
        return super.m_204075_(pTag);
    }

    public void m_36006_(Inventory pPlayerInventory) {
        super.m_36006_(pPlayerInventory);
    }

    public void m_6211_() {
        super.m_6211_();
    }

    public void m_36010_(StackedContents pStackedContent) {
        super.m_36010_(pStackedContent);
    }

    public ItemStack m_182403_(boolean pRemoveStack) {
        return super.m_182403_(pRemoveStack);
    }

    public int m_6893_() {
        return super.m_6893_();
    }

    public void m_5856_(Player pPlayer) {
        super.m_5856_(pPlayer);
    }

    public void m_5785_(Player pPlayer) {
        super.m_5785_(pPlayer);
    }

    public boolean m_8077_() {
        return super.m_8077_();
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public Component m_7770_() {
        return super.m_7770_();
    }

    public int m_6643_() {
        return this.getInv().getSlots();
    }

    public int m_36030_(ItemStack stack) {
        return 0;
    }

    public int m_36043_(ItemStack stack) {
        return 0;
    }

    public int m_36065_() {
        return 0;
    }

    public void m_35988_(double pDirection) {
    }

    public int m_36022_(Predicate<ItemStack> pStackPredicate, int pMaxCount, Container pInventory) {
        return 0;
    }

    public int m_36050_(ItemStack stack) {
        return 0;
    }

    public boolean m_36040_(int pSlot, ItemStack stack) {
        return false;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public boolean m_271862_(Container pTarget, int index, ItemStack stack) {
        return false;
    }

    public void m_36038_(int index) {
    }

    public ItemStack m_8020_(int index) {
        return this.getInv().getStackInSlot(index);
    }

    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.getInv().setStackInSlot(index, stack);
    }

    public ItemStack m_7407_(int index, int pCount) {
        return this.getInv().getStackInSlot(index).m_41620_(pCount);
    }

    public int m_36062_() {
        IItemHandlerModifiable inv = this.getInv();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }
}

