package com.github.wallev.maidsoulkitchen.task.cook.brewinandchewin.keg;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.api.task.cook.ICookTask;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskInfo;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidConditionCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.modclazzchecker.manager.TaskClassAnalyzer;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;

@TaskClassAnalyzer(TaskInfo.BNC_KEY)
public class MaidKegCookManager extends MaidConditionCookManager<KegFermentingRecipe, Integer> {
    public MaidKegCookManager(RecSerializerManager<KegFermentingRecipe> recSerializerManager, EntityMaid maid, ICookTask<?, KegFermentingRecipe> task, CookBeBase<?> cookBeBase) {
        super(recSerializerManager, maid, task, cookBeBase);
    }

    @Override
    protected Integer getRecipeCondition(KegFermentingRecipe kegFermentingRecipe) {
        return kegFermentingRecipe.getTemperature();
    }

    @Override
    protected Integer getBeCondition(CookBeBase<?> cookBeBase) {
        return ((KegBlockEntity) cookBeBase.getBe()).getTemperature();
    }

    @Override
    protected boolean isValid(Integer be, Integer rCondition) {
        return KegBlockEntity.isValidTemp(be, rCondition);
    }
}
