/*
 * Decompiled with CFR 0.152.
 */
package xox.labvorty.weaversparadise.events;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import xox.labvorty.weaversparadise.items.LeatherGloves;

@EventBusSubscriber
public class WeaversParadiseClothingEvents {
    private static List<ResourceKey<DamageType>> vanillaDurabilityFriendly = List.of(DamageTypes.CAMPFIRE, DamageTypes.CRAMMING, DamageTypes.DRAGON_BREATH, DamageTypes.DROWN, DamageTypes.FALL, DamageTypes.FIREBALL, DamageTypes.FLY_INTO_WALL, DamageTypes.FREEZE, DamageTypes.GENERIC, DamageTypes.GENERIC_KILL, DamageTypes.HOT_FLOOR, DamageTypes.IN_FIRE, DamageTypes.IN_WALL, DamageTypes.INDIRECT_MAGIC, DamageTypes.LAVA, DamageTypes.MAGIC, DamageTypes.ON_FIRE, DamageTypes.FELL_OUT_OF_WORLD, DamageTypes.OUTSIDE_BORDER, DamageTypes.STALAGMITE, DamageTypes.STARVE, DamageTypes.UNATTRIBUTED_FIREBALL, DamageTypes.WITHER);

    @SubscribeEvent
    public static void entityHurt(LivingDamageEvent.Post event) {
        String slotType;
        Optional itemInventory;
        ResourceKey damageType = event.getSource().typeHolder().getKey();
        LivingEntity receivingEntity = event.getEntity();
        Entity sourceEntity = event.getSource().getEntity();
        float damage = event.getOriginalDamage();
        int durabilityDamageHead = 0;
        int durabilityDamageBody = 0;
        int durabilityDamageLegs = 0;
        int durabilityDamageFeet = 0;
        Optional curiohandler = CuriosApi.getCuriosInventory((LivingEntity)receivingEntity);
        if (damageType.equals(DamageTypes.FALLING_ANVIL) || damageType.equals(DamageTypes.FALLING_BLOCK) || damageType.equals(DamageTypes.FALLING_STALACTITE)) {
            durabilityDamageHead = Mth.clamp((int)((int)((double)damage * 0.3)), (int)1, (int)Integer.MAX_VALUE);
            durabilityDamageBody = Mth.clamp((int)((int)((double)damage * 0.1)), (int)1, (int)Integer.MAX_VALUE);
            durabilityDamageLegs = Mth.clamp((int)((int)((double)damage * 0.1)), (int)1, (int)Integer.MAX_VALUE);
            durabilityDamageFeet = Mth.clamp((int)((int)((double)damage * 0.1)), (int)1, (int)Integer.MAX_VALUE);
        } else {
            durabilityDamageHead = Mth.clamp((int)((int)((double)damage * 0.2)), (int)1, (int)Integer.MAX_VALUE);
            durabilityDamageBody = Mth.clamp((int)((int)((double)damage * 0.2)), (int)1, (int)Integer.MAX_VALUE);
            durabilityDamageLegs = Mth.clamp((int)((int)((double)damage * 0.2)), (int)1, (int)Integer.MAX_VALUE);
            durabilityDamageFeet = Mth.clamp((int)((int)((double)damage * 0.2)), (int)1, (int)Integer.MAX_VALUE);
        }
        if (!vanillaDurabilityFriendly.contains(damageType)) {
            RandomSource randomSource;
            int i;
            int unbreakingLevel;
            int receivedDamage;
            ItemStack itemStack;
            List curios;
            if (!receivingEntity.hasItemInSlot(EquipmentSlot.FEET) && !receivingEntity.hasItemInSlot(EquipmentSlot.LEGS) && curiohandler.isPresent()) {
                itemInventory = CuriosApi.getCuriosInventory((LivingEntity)receivingEntity);
                slotType = "legwear";
                curios = itemInventory.map(handler -> {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get(slotType);
                    if (stacksHandler == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<SlotResult> results = new ArrayList<SlotResult>();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        results.add(new SlotResult(new SlotContext(slotType, receivingEntity, i, false, true), stacksHandler.getStacks().getStackInSlot(i)));
                    }
                    return results;
                }).orElse(Collections.emptyList());
                for (SlotResult entry : curios) {
                    itemStack = entry.stack();
                    receivedDamage = durabilityDamageFeet;
                    if (WeaversParadiseClothingEvents.hasUnbreaking(itemStack)) {
                        receivedDamage = 0;
                        unbreakingLevel = WeaversParadiseClothingEvents.getUnbreakingLevel(itemStack);
                        for (i = 0; i < unbreakingLevel; ++i) {
                            randomSource = RandomSource.create();
                            if (!WeaversParadiseClothingEvents.shouldReceiveDamage(itemStack, randomSource)) continue;
                            ++receivedDamage;
                        }
                    }
                    itemStack.hurtAndBreak(receivedDamage, receivingEntity, EquipmentSlot.MAINHAND);
                    ((ICuriosItemHandler)curiohandler.get()).setEquippedCurio(entry.slotContext().identifier(), entry.slotContext().index(), itemStack);
                }
            }
            if (!receivingEntity.hasItemInSlot(EquipmentSlot.CHEST) && curiohandler.isPresent()) {
                itemInventory = CuriosApi.getCuriosInventory((LivingEntity)receivingEntity);
                slotType = "upperwear";
                curios = itemInventory.map(handler -> {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get(slotType);
                    if (stacksHandler == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<SlotResult> results = new ArrayList<SlotResult>();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        results.add(new SlotResult(new SlotContext(slotType, receivingEntity, i, false, true), stacksHandler.getStacks().getStackInSlot(i)));
                    }
                    return results;
                }).orElse(Collections.emptyList());
                for (SlotResult entry : curios) {
                    itemStack = entry.stack();
                    receivedDamage = durabilityDamageFeet;
                    if (WeaversParadiseClothingEvents.hasUnbreaking(itemStack)) {
                        receivedDamage = 0;
                        unbreakingLevel = WeaversParadiseClothingEvents.getUnbreakingLevel(itemStack);
                        for (i = 0; i < unbreakingLevel; ++i) {
                            randomSource = RandomSource.create();
                            if (!WeaversParadiseClothingEvents.shouldReceiveDamage(itemStack, randomSource)) continue;
                            ++receivedDamage;
                        }
                    }
                    itemStack.hurtAndBreak(receivedDamage, receivingEntity, EquipmentSlot.MAINHAND);
                    ((ICuriosItemHandler)curiohandler.get()).setEquippedCurio(entry.slotContext().identifier(), entry.slotContext().index(), itemStack);
                }
                String glovesslotType = "gloves";
                List glovescurios = itemInventory.map(handler -> {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get(glovesslotType);
                    if (stacksHandler == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<SlotResult> results = new ArrayList<SlotResult>();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        results.add(new SlotResult(new SlotContext(glovesslotType, receivingEntity, i, false, true), stacksHandler.getStacks().getStackInSlot(i)));
                    }
                    return results;
                }).orElse(Collections.emptyList());
                for (SlotResult entry : glovescurios) {
                    ItemStack itemStack2 = entry.stack();
                    Item randomSource2 = itemStack2.getItem();
                    if (randomSource2 instanceof LeatherGloves) {
                        LeatherGloves leatherGloves = (LeatherGloves)randomSource2;
                        continue;
                    }
                    int receivedDamage2 = durabilityDamageFeet;
                    if (WeaversParadiseClothingEvents.hasUnbreaking(itemStack2)) {
                        receivedDamage2 = 0;
                        int unbreakingLevel2 = WeaversParadiseClothingEvents.getUnbreakingLevel(itemStack2);
                        for (int i2 = 0; i2 < unbreakingLevel2; ++i2) {
                            RandomSource randomSource3 = RandomSource.create();
                            if (!WeaversParadiseClothingEvents.shouldReceiveDamage(itemStack2, randomSource3)) continue;
                            ++receivedDamage2;
                        }
                    }
                    itemStack2.hurtAndBreak(receivedDamage2, receivingEntity, EquipmentSlot.MAINHAND);
                    ((ICuriosItemHandler)curiohandler.get()).setEquippedCurio(entry.slotContext().identifier(), entry.slotContext().index(), itemStack2);
                }
            }
        }
        if (damageType.equals(DamageTypes.FALL) && curiohandler.isPresent()) {
            itemInventory = CuriosApi.getCuriosInventory((LivingEntity)receivingEntity);
            slotType = "legwear";
            List list = itemInventory.map(handler -> {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get(slotType);
                if (stacksHandler == null) {
                    return Collections.emptyList();
                }
                ArrayList<SlotResult> results = new ArrayList<SlotResult>();
                for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                    results.add(new SlotResult(new SlotContext(slotType, receivingEntity, i, false, true), stacksHandler.getStacks().getStackInSlot(i)));
                }
                return results;
            }).orElse(Collections.emptyList());
        }
    }

    public static boolean hasUnbreaking(ItemStack stack) {
        if (stack.isEnchanted()) {
            boolean hasUnbreaking = false;
            ItemEnchantments itemEnchantments = stack.getTagEnchantments();
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Holder enchantmentHolder = (Holder)entry.getKey();
                if (!enchantmentHolder.is(Enchantments.UNBREAKING)) continue;
                hasUnbreaking = true;
                break;
            }
            return hasUnbreaking;
        }
        return false;
    }

    public static int getUnbreakingLevel(ItemStack stack) {
        if (stack.isEnchanted()) {
            int level = 0;
            ItemEnchantments itemEnchantments = stack.getTagEnchantments();
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Holder enchantmentHolder = (Holder)entry.getKey();
                if (!enchantmentHolder.is(Enchantments.UNBREAKING)) continue;
                level = stack.getEnchantmentLevel(enchantmentHolder);
                break;
            }
            return level;
        }
        return 0;
    }

    public static boolean shouldReceiveDamage(ItemStack stack, RandomSource randomSource) {
        if (stack.isEnchanted()) {
            int level = 0;
            ItemEnchantments itemEnchantments = stack.getTagEnchantments();
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Holder enchantmentHolder = (Holder)entry.getKey();
                if (!enchantmentHolder.is(Enchantments.UNBREAKING)) continue;
                level = stack.getEnchantmentLevel(enchantmentHolder);
            }
            return randomSource.nextIntBetweenInclusive(0, level) == 0;
        }
        return true;
    }
}

